/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;

public class InetUtilsTests {
    @Test
    public void testGetFirstNonLoopbackHostInfo() {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            BDDAssertions.then((Object)utils.findFirstNonLoopbackHostInfo()).isNotNull();
        }
    }

    @Test
    public void testGetFirstNonLoopbackAddress() {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            BDDAssertions.then((Object)utils.findFirstNonLoopbackAddress()).isNotNull();
        }
    }

    @Test
    public void testConvert() throws Exception {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            BDDAssertions.then((Object)utils.convertAddress(InetAddress.getByName("localhost"))).isNotNull();
        }
    }

    @Test
    public void testHostInfo() {
        try (InetUtils utils = new InetUtils(new InetUtilsProperties());){
            InetUtils.HostInfo info = utils.findFirstNonLoopbackHostInfo();
            BDDAssertions.then((int)info.getIpAddressAsInt()).isNotNull();
        }
    }

    @Test
    public void testIgnoreInterface() {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setIgnoredInterfaces(Arrays.asList("docker0", "veth.*"));
        try (InetUtils inetUtils = new InetUtils(properties);){
            BDDAssertions.then((boolean)inetUtils.ignoreInterface("docker0")).isTrue().as("docker0 not ignored", new Object[0]);
            ((AbstractBooleanAssert)BDDAssertions.then((boolean)inetUtils.ignoreInterface("vethAQI2QT")).as("vethAQI2QT0 not ignored", new Object[0])).isTrue();
            ((AbstractBooleanAssert)BDDAssertions.then((boolean)inetUtils.ignoreInterface("docker1")).as("docker1 ignored", new Object[0])).isFalse();
        }
    }

    @Test
    public void testDefaultIgnoreInterface() {
        try (InetUtils inetUtils = new InetUtils(new InetUtilsProperties());){
            ((AbstractBooleanAssert)BDDAssertions.then((boolean)inetUtils.ignoreInterface("docker0")).as("docker0 ignored", new Object[0])).isFalse();
        }
    }

    @Test
    public void testSiteLocalAddresses() throws Exception {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setUseOnlySiteLocalInterfaces(true);
        try (InetUtils utils = new InetUtils(properties);){
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("192.168.0.1"))).isTrue();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("5.5.8.1"))).isFalse();
        }
    }

    @Test
    public void testPreferredNetworksRegex() throws Exception {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setPreferredNetworks(Arrays.asList("192.168.*", "10.0.*"));
        try (InetUtils utils = new InetUtils(properties);){
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("192.168.0.1"))).isTrue();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("5.5.8.1"))).isFalse();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("10.0.10.1"))).isTrue();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("10.255.10.1"))).isFalse();
        }
    }

    @Test
    public void testPreferredNetworksSimple() throws Exception {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setPreferredNetworks(Arrays.asList("192", "10.0"));
        try (InetUtils utils = new InetUtils(properties);){
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("192.168.0.1"))).isTrue();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("5.5.8.1"))).isFalse();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("10.255.10.1"))).isFalse();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("10.0.10.1"))).isTrue();
        }
    }

    @Test
    public void testPreferredNetworksListIsEmpty() throws Exception {
        InetUtilsProperties properties = new InetUtilsProperties();
        properties.setPreferredNetworks(Collections.emptyList());
        try (InetUtils utils = new InetUtils(properties);){
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("192.168.0.1"))).isTrue();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("5.5.8.1"))).isTrue();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("10.255.10.1"))).isTrue();
            BDDAssertions.then((boolean)utils.isPreferredAddress(InetAddress.getByName("10.0.10.1"))).isTrue();
        }
    }
}

