/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.configuration.CompatibilityVerifier;
import org.springframework.cloud.configuration.CompatibilityVerifierProperties;
import org.springframework.cloud.configuration.SpringBootVersionVerifier;
import org.springframework.cloud.configuration.VerificationResult;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest
public class CompatibilityVerifierAutoConfigurationTests {
    @Autowired
    MyCompatibilityVerifier myMismatchVerifier;
    @Autowired
    CompatibilityVerifierProperties verifierProperties;

    @Test
    public void contextLoads() {
        BDDAssertions.then((boolean)this.myMismatchVerifier.called).isTrue();
    }

    @Test
    public void verifierPropertiesContainsCurrentBootVersion() {
        String version = SpringBootVersion.getVersion();
        Assertions.assertThat((String)version).isNotBlank();
        for (String compatibleVersion : this.verifierProperties.getCompatibleBootVersions()) {
            if (!version.startsWith(SpringBootVersionVerifier.stripWildCardFromVersion((String)compatibleVersion))) continue;
            return;
        }
        Assertions.fail((String)(version + " not found in " + this.verifierProperties.getCompatibleBootVersions()));
    }

    private static class MyCompatibilityVerifier
    implements CompatibilityVerifier {
        boolean called;

        private MyCompatibilityVerifier() {
        }

        public VerificationResult verify() {
            this.called = true;
            return VerificationResult.compatible();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    static class TestConfiguration {
        TestConfiguration() {
        }

        @Bean
        MyCompatibilityVerifier myMismatchVerifier() {
            return new MyCompatibilityVerifier();
        }
    }
}

