/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.system.OutputCaptureRule;
import org.springframework.cloud.configuration.CompatibilityNotMetException;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.NestedExceptionUtils;

public class CompatibilityVerifierFailureAutoConfigurationTests {
    @Rule
    public OutputCaptureRule outputCapture = new OutputCaptureRule();

    @Test
    public void contextFailsToLoad() {
        try {
            SpringApplication.run(TestConfiguration.class, (String[])new String[]{"--spring.cloud.compatibility-verifier.compatible-boot-versions=1.2.x,1.3.x"});
            BDDAssertions.fail((String)"should throw exception");
        }
        catch (BeanCreationException ex) {
            Throwable cause = NestedExceptionUtils.getRootCause((Throwable)ex);
            BDDAssertions.then((List)((CompatibilityNotMetException)cause).results).hasSize(1);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    static class TestConfiguration {
        TestConfiguration() {
        }
    }
}

