/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.springframework.cloud.configuration.KeyTool;

public class KeyAndCert {
    private KeyPair keyPair;
    private X509Certificate certificate;

    public KeyAndCert(KeyPair keyPair, X509Certificate certificate) {
        this.keyPair = keyPair;
        this.certificate = certificate;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public PublicKey publicKey() {
        return this.keyPair.getPublic();
    }

    public PrivateKey privateKey() {
        return this.keyPair.getPrivate();
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public String subject() {
        String dn = this.certificate.getSubjectDN().getName();
        int index = dn.indexOf(61);
        return dn.substring(index + 1);
    }

    public KeyAndCert sign(String subject) throws Exception {
        KeyTool tool = new KeyTool();
        return tool.signCertificate(subject, this);
    }

    public KeyAndCert sign(KeyPair keyPair, String subject) throws Exception {
        KeyTool tool = new KeyTool();
        return tool.signCertificate(keyPair, subject, this);
    }

    public KeyStore storeKeyAndCert(String keyPassword) throws Exception {
        KeyStore result = KeyStore.getInstance("PKCS12");
        result.load(null);
        result.setKeyEntry(this.subject(), this.keyPair.getPrivate(), keyPassword.toCharArray(), this.certChain());
        return result;
    }

    private Certificate[] certChain() {
        return new Certificate[]{this.certificate()};
    }

    public KeyStore storeCert() throws Exception {
        return this.storeCert("PKCS12");
    }

    public KeyStore storeCert(String storeType) throws Exception {
        KeyStore result = KeyStore.getInstance(storeType);
        result.load(null);
        result.setCertificateEntry(this.subject(), this.certificate());
        return result;
    }
}

