/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.springframework.cloud.configuration.KeyAndCert;

public class KeyTool {
    private static final long ONE_DAY = 86400000L;
    private static final long TEN_YEARS = 315360000000L;

    public KeyAndCert createCA(String ca) throws Exception {
        KeyPair keyPair = this.createKeyPair();
        X509Certificate certificate = this.createCert(keyPair, ca);
        return new KeyAndCert(keyPair, certificate);
    }

    public KeyAndCert signCertificate(String subject, KeyAndCert signer) throws Exception {
        return this.signCertificate(this.createKeyPair(), subject, signer);
    }

    public KeyAndCert signCertificate(KeyPair keyPair, String subject, KeyAndCert signer) throws Exception {
        X509Certificate certificate = this.createCert(keyPair.getPublic(), signer.privateKey(), signer.subject(), subject);
        KeyAndCert result = new KeyAndCert(keyPair, certificate);
        return result;
    }

    public KeyPair createKeyPair() throws Exception {
        return this.createKeyPair(1024);
    }

    public KeyPair createKeyPair(int keySize) throws Exception {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
        gen.initialize(keySize, new SecureRandom());
        return gen.generateKeyPair();
    }

    public X509Certificate createCert(KeyPair keyPair, String ca) throws Exception {
        JcaX509v3CertificateBuilder builder = this.certBuilder(keyPair.getPublic(), ca, ca);
        builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(4));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
        return this.signCert(builder, keyPair.getPrivate());
    }

    public X509Certificate createCert(PublicKey publicKey, PrivateKey privateKey, String issuer, String subject) throws Exception {
        JcaX509v3CertificateBuilder builder = this.certBuilder(publicKey, issuer, subject);
        builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        GeneralName[] names = new GeneralName[]{new GeneralName(2, "localhost")};
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable[])names)));
        return this.signCert(builder, privateKey);
    }

    private JcaX509v3CertificateBuilder certBuilder(PublicKey publicKey, String issuer, String subject) {
        X500Name issuerName = new X500Name(String.format("dc=%s", issuer));
        X500Name subjectName = new X500Name(String.format("dc=%s", subject));
        long now = System.currentTimeMillis();
        BigInteger serialNum = BigInteger.valueOf(now);
        Date notBefore = new Date(now - 86400000L);
        Date notAfter = new Date(now + 315360000000L);
        return new JcaX509v3CertificateBuilder(issuerName, serialNum, notBefore, notAfter, subjectName, publicKey);
    }

    private X509Certificate signCert(JcaX509v3CertificateBuilder builder, PrivateKey privateKey) throws Exception {
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSA").build(privateKey);
        X509CertificateHolder holder = builder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(holder);
    }
}

