/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.cloud.configuration.KeyAndCert;
import org.springframework.cloud.configuration.KeyTool;
import org.springframework.cloud.configuration.SSLContextFactory;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SSHContextFactoryTests {
    private static final String KEY_STORE_PASSWORD = "test-key-store-password";
    private static final String KEY_PASSWORD = "test-key-password";
    private static KeyAndCert ca;
    private static KeyAndCert cert;
    private static File keyStore;
    private static File trustStore;
    private TlsProperties properties;

    @BeforeClass
    public static void createKeyStoreAndTrustStore() throws Exception {
        KeyTool tool = new KeyTool();
        ca = tool.createCA("MyCA");
        cert = ca.sign("MyCert");
        keyStore = SSHContextFactoryTests.saveKeyAndCert(cert);
        trustStore = SSHContextFactoryTests.saveCert(ca);
    }

    private static File saveKeyAndCert(KeyAndCert keyCert) throws Exception {
        return SSHContextFactoryTests.saveKeyStore(keyCert.subject(), () -> keyCert.storeKeyAndCert(KEY_PASSWORD));
    }

    private static File saveCert(KeyAndCert keyCert) throws Exception {
        return SSHContextFactoryTests.saveKeyStore(keyCert.subject(), () -> keyCert.storeCert());
    }

    private static File saveKeyStore(String prefix, KeyStoreSupplier func) throws Exception {
        File result = File.createTempFile(prefix, ".p12");
        result.deleteOnExit();
        try (FileOutputStream output = new FileOutputStream(result);){
            KeyStore store = func.createKeyStore();
            store.store(output, KEY_STORE_PASSWORD.toCharArray());
        }
        return result;
    }

    @Before
    public void createProperties() {
        this.properties = new TlsProperties();
        this.properties.setEnabled(true);
        this.properties.setKeyStore(this.resourceOf(keyStore));
        this.properties.setKeyStorePassword(KEY_STORE_PASSWORD);
        this.properties.setKeyPassword(KEY_PASSWORD);
        this.properties.setTrustStore(this.resourceOf(trustStore));
        this.properties.setTrustStorePassword(KEY_STORE_PASSWORD);
        this.properties.postConstruct();
    }

    private Resource resourceOf(File file) {
        return new FileSystemResource(file);
    }

    @Test
    public void createKeyStoreFromProperties() throws GeneralSecurityException, IOException {
        SSLContextFactory factory = new SSLContextFactory(this.properties);
        KeyStore store = factory.createKeyStore();
        Certificate c = store.getCertificate("MyCert");
        Assertions.assertThat((Object)c).isEqualTo((Object)cert.certificate());
        Key key = store.getKey("MyCert", KEY_PASSWORD.toCharArray());
        Assertions.assertThat((Object)key).isEqualTo((Object)cert.privateKey());
    }

    @Test
    public void createTrustStoreFromProperties() throws GeneralSecurityException, IOException {
        SSLContextFactory factory = new SSLContextFactory(this.properties);
        KeyStore store = factory.createTrustStore();
        Certificate c = store.getCertificate("MyCA");
        Assertions.assertThat((Object)c).isEqualTo((Object)ca.certificate());
    }

    @Test
    public void createSSLContextFromProperties() throws GeneralSecurityException, IOException {
        SSLContextFactory factory = new SSLContextFactory(this.properties);
        SSLContext context = factory.createSSLContext();
        Assertions.assertThat((Object)context).isNotNull();
    }

    static interface KeyStoreSupplier {
        public KeyStore createKeyStore() throws Exception;
    }
}

