/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.cloud.configuration.CompatibilityPredicate;
import org.springframework.cloud.configuration.SpringBootVersionVerifier;
import org.springframework.cloud.configuration.VerificationResult;

public class SpringBootDependencyTests {
    @Test
    public void should_read_concrete_version_from_manifest() {
        List<String> acceptedVersions = Collections.singletonList("2.1.3.RELEASE");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "2.1.3.RELEASE";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isEmpty();
        BDDAssertions.then((String)verificationResult.action).isEmpty();
    }

    @Test
    public void should_read_concrete_version_from_manifest_and_return_false_when_version_is_not_matched() {
        List<String> acceptedVersions = Collections.singletonList("2.1.9.RELEASE");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "2.1.3.RELEASE";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isNotEmpty();
        BDDAssertions.then((String)verificationResult.action).isNotEmpty();
    }

    @Test
    public void should_read_concrete_version_from_manifest_and_return_false_when_minor_version_is_not_matched() {
        List<String> acceptedVersions = Collections.singletonList("2.1");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "2.99.3.RELEASE";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isNotEmpty();
        BDDAssertions.then((String)verificationResult.action).isNotEmpty();
    }

    @Test
    public void should_read_concrete_version_from_manifest_and_match_it_against_minor_version() {
        List<String> acceptedVersions = Collections.singletonList("2.1");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "2.1.3.RELEASE";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isEmpty();
        BDDAssertions.then((String)verificationResult.action).isEmpty();
    }

    @Test
    public void should_match_against_predicate() {
        List<String> acceptedVersions = Collections.singletonList("2.5");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        versionVerifier.ACCEPTED_VERSIONS.put("2.5", new CompatibilityPredicate(){

            public boolean isCompatible() {
                return true;
            }
        });
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isEmpty();
        BDDAssertions.then((String)verificationResult.action).isEmpty();
    }

    @Test
    public void should_fail_to_match_against_predicate_when_none_is_matching() {
        List<String> acceptedVersions = Collections.singletonList("2.5");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "2.1";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isNotEmpty();
        BDDAssertions.then((String)verificationResult.action).isNotEmpty();
    }

    @Ignore
    @Test
    public void should_match_against_current_manifest() {
        this.verifyCurrentVersionFromManifest("2.3");
        this.verifyCurrentVersionFromManifest("2.3.x");
    }

    private void verifyCurrentVersionFromManifest(String version) {
        List<String> acceptedVersions = Collections.singletonList(version);
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions);
        versionVerifier.ACCEPTED_VERSIONS.clear();
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isEmpty();
        BDDAssertions.then((String)verificationResult.action).isEmpty();
    }

    @Test
    public void should_match_against_current_predicate() {
        List<String> acceptedVersions = Collections.singletonList("2.1");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        versionVerifier.ACCEPTED_VERSIONS.put("2.1", versionVerifier.is2_1());
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isEmpty();
        BDDAssertions.then((String)verificationResult.action).isEmpty();
    }

    @Test
    public void should_match_against_current_predicate_with_version_ending_with_x() {
        List<String> acceptedVersions = Collections.singletonList("2.1.x");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.clear();
        versionVerifier.ACCEPTED_VERSIONS.put("2.1", versionVerifier.is2_1());
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isEmpty();
        BDDAssertions.then((String)verificationResult.action).isEmpty();
    }

    @Test
    public void should_fail_to_match_against_predicate_for_non_current_versions() {
        List<String> acceptedVersions = Collections.singletonList("2.1");
        SpringBootVersionVerifier versionVerifier = new SpringBootVersionVerifier(acceptedVersions){

            String getVersionFromManifest() {
                return "2.0";
            }
        };
        versionVerifier.ACCEPTED_VERSIONS.remove("2.1");
        VerificationResult verificationResult = versionVerifier.verify();
        BDDAssertions.then((String)verificationResult.description).isNotEmpty();
        BDDAssertions.then((String)verificationResult.action).isNotEmpty();
    }
}

