/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.CloudFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxFirstNonEmptyEmitting;
import reactor.core.publisher.LambdaSubscriber;
import reactor.core.publisher.Operators;
import reactor.test.StepVerifier;

public class FluxFirstNonEmptyEmittingTests {
    @Test
    public void arrayNull() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> CloudFlux.firstNonEmpty((Publisher[])null));
    }

    @Test
    public void iterableNull() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> CloudFlux.firstNonEmpty((Iterable)null));
    }

    @Test
    public void firstWinner() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.range((int)1, (int)10), Flux.range((int)11, (int)10)})).expectNext((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).verifyComplete();
    }

    @Test
    public void firstWinnerSecondEmpty() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.range((int)1, (int)10), Flux.empty()})).expectNext((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).verifyComplete();
    }

    @Test
    public void firstWinnerBackpressured() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.range((int)1, (int)10), Flux.range((int)11, (int)10)})).thenRequest(5L).expectNext((Object)1, (Object)2, (Object)3, (Object)4, (Object)5).thenCancel().verifyThenAssertThat().hasNotDiscardedElements().hasNotDroppedElements().hasNotDroppedErrors();
    }

    @Test
    public void secondWinner() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.never(), Flux.range((int)11, (int)10).log()})).expectNext((Object[])new Integer[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20}).verifyComplete();
    }

    @Test
    public void secondWinnerFirstEmpty() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.empty(), Flux.range((int)11, (int)10).log()})).expectNext((Object[])new Integer[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20}).verifyComplete();
    }

    @Test
    public void bothEmpty() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.empty(), Flux.empty()})).expectComplete().verifyThenAssertThat().hasNotDiscardedElements().hasNotDroppedElements().hasNotDroppedErrors();
    }

    @Test
    public void neverAndEmpty() {
        StepVerifier.withVirtualTime(() -> CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.never(), Flux.empty()})).expectSubscription().expectNoEvent(Duration.ofDays(1L)).thenCancel().verifyThenAssertThat().hasNotDiscardedElements().hasNotDroppedElements().hasNotDroppedErrors();
    }

    @Test
    public void firstEmitsError() {
        RuntimeException ex = new RuntimeException("forced failure");
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.error((Throwable)ex), Flux.empty()})).expectErrorMessage("forced failure").verifyThenAssertThat().hasNotDiscardedElements().hasNotDroppedElements().hasNotDroppedErrors();
    }

    @Test
    public void secondEmitsError() {
        RuntimeException ex = new RuntimeException("forced failure");
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.empty(), Flux.error((Throwable)ex)})).expectErrorMessage("forced failure").verifyThenAssertThat().hasNotDiscardedElements().hasNotDroppedElements().hasNotDroppedErrors();
    }

    @Test
    public void neverAndSecondEmitsError() {
        RuntimeException ex = new RuntimeException("forced failure");
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.never(), Flux.error((Throwable)ex)})).expectErrorMessage("forced failure").verifyThenAssertThat().hasNotDiscardedElements().hasNotDroppedElements().hasNotDroppedErrors();
    }

    @Test
    public void singleArrayNullSource() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{null})).expectError(NullPointerException.class).verify();
    }

    @Test
    public void arrayOneIsNullSource() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty((Publisher[])new Publisher[]{Flux.never(), null, Flux.never()})).expectError(NullPointerException.class).verify();
    }

    @Test
    public void singleIterableNullSource() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty(Collections.singletonList(null))).expectError(NullPointerException.class).verify();
    }

    @Test
    public void iterableOneIsNullSource() {
        StepVerifier.create((Publisher)CloudFlux.firstNonEmpty(Arrays.asList(Flux.never(), null, Flux.never()))).expectError(NullPointerException.class).verify();
    }

    @Test
    public void scanSubscriber() {
        LambdaSubscriber actual = new LambdaSubscriber(null, e -> {}, null, null);
        FluxFirstNonEmptyEmitting.RaceCoordinator parent = new FluxFirstNonEmptyEmitting.RaceCoordinator(1);
        FluxFirstNonEmptyEmitting.FirstNonEmptyEmittingSubscriber test = new FluxFirstNonEmptyEmitting.FirstNonEmptyEmittingSubscriber((CoreSubscriber)actual, parent, 1);
        Subscription sub = Operators.emptySubscription();
        test.onSubscribe(sub);
        Assertions.assertThat((Object)test.scan(Scannable.Attr.PARENT)).isSameAs((Object)sub);
        Assertions.assertThat((Object)test.scan(Scannable.Attr.ACTUAL)).isSameAs((Object)actual);
        Assertions.assertThat((Boolean)((Boolean)test.scan(Scannable.Attr.CANCELLED))).isFalse();
        parent.cancelled = true;
        Assertions.assertThat((Boolean)((Boolean)test.scan(Scannable.Attr.CANCELLED))).isTrue();
    }

    @Test
    public void scanRaceCoordinator() {
        LambdaSubscriber actual = new LambdaSubscriber(null, e -> {}, null, null);
        FluxFirstNonEmptyEmitting.RaceCoordinator parent = new FluxFirstNonEmptyEmitting.RaceCoordinator(1);
        FluxFirstNonEmptyEmitting.FirstNonEmptyEmittingSubscriber test = new FluxFirstNonEmptyEmitting.FirstNonEmptyEmittingSubscriber((CoreSubscriber)actual, parent, 1);
        Subscription sub = Operators.emptySubscription();
        test.onSubscribe(sub);
        Assertions.assertThat((Object)test.scan(Scannable.Attr.PARENT)).isSameAs((Object)sub);
        Assertions.assertThat((Object)test.scan(Scannable.Attr.ACTUAL)).isSameAs((Object)actual);
        Assertions.assertThat((Boolean)((Boolean)parent.scan(Scannable.Attr.CANCELLED))).isFalse();
        parent.cancelled = true;
        Assertions.assertThat((Boolean)((Boolean)parent.scan(Scannable.Attr.CANCELLED))).isTrue();
    }
}

