/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.cloud.config.Environment;
import org.springframework.cloud.config.PropertySource;
import org.springframework.cloud.config.server.EncryptionController;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.Yaml;

@RestController
@RequestMapping(value={"${spring.cloud.config.server.prefix:}"})
public class EnvironmentController {
    private EnvironmentRepository repository;
    private EncryptionController encryption;
    private String defaultLabel = "master";
    private Map<String, String> overrides = new LinkedHashMap<String, String>();

    @Autowired
    public EnvironmentController(EnvironmentRepository repository, EncryptionController encryption) {
        this.repository = repository;
        this.encryption = encryption;
    }

    @RequestMapping(value={"/{name}/{profiles:.*[^-].*}"})
    public Environment master(@PathVariable String name, @PathVariable String profiles) {
        return this.labelled(name, profiles, this.defaultLabel);
    }

    @RequestMapping(value={"/{name}/{profiles}/{label}"})
    public Environment labelled(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) {
        Environment environment = this.encryption.decrypt(this.repository.findOne(name, profiles, label));
        if (!this.overrides.isEmpty()) {
            environment.addFirst(new PropertySource("overrides", this.overrides));
        }
        return environment;
    }

    @RequestMapping(value={"/{name}-{profiles}.properties"})
    public ResponseEntity<String> properties(@PathVariable String name, @PathVariable String profiles) throws IOException {
        return this.labelledProperties(name, profiles, this.defaultLabel);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.properties"})
    public ResponseEntity<String> labelledProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) throws IOException {
        if (name.contains("-") || profiles.contains("-")) {
            throw new IllegalArgumentException("Properties output not supported for name or profiles containing hyphens");
        }
        Properties properties = this.convertToProperties(this.labelled(name, profiles, label));
        return this.getSuccess(this.sortLines(properties));
    }

    private String sortLines(Properties properties) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey().equals("spring.profiles")) continue;
            String line = entry.getKey() + ": " + entry.getValue();
            list.add(line);
        }
        Collections.sort(list);
        StringBuilder output = new StringBuilder();
        for (String item : list) {
            if (output.length() > 0) {
                output.append("\n");
            }
            output.append(item);
        }
        return output.toString();
    }

    @RequestMapping(value={"/{name}-{profiles}.yml", "/{name}-{profiles}.yaml"})
    public ResponseEntity<String> yaml(@PathVariable String name, @PathVariable String profiles) throws Exception {
        return this.labelledYaml(name, profiles, this.defaultLabel);
    }

    @RequestMapping(value={"/{label}/{name}-{profiles}.yml", "/{label}/{name}-{profiles}.yaml"})
    public ResponseEntity<String> labelledYaml(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) throws Exception {
        if (name.contains("-") || profiles.contains("-")) {
            throw new IllegalArgumentException("YAML output not supported for name or profiles containing hyphens");
        }
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(target);
        Properties properties = this.convertToProperties(this.labelled(name, profiles, label));
        this.addArrays(target, properties);
        factory.setProperties(properties);
        factory.bindPropertiesToTarget();
        Map input = (Map)factory.getObject();
        return this.getSuccess(new Yaml().dumpAsMap((Object)input));
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public void illegalArgument(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value());
    }

    private ResponseEntity<String> getSuccess(String body) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)body, (MultiValueMap)headers, HttpStatus.OK);
    }

    private void addArrays(LinkedHashMap<String, Object> target, Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            int index = key.indexOf("[");
            Map<String, Object> current = target;
            if (index <= 0) continue;
            String stem = key.substring(0, index);
            String[] keys = StringUtils.split((String)stem, (String)".");
            int i = 0;
            while (i < keys.length - 1) {
                Map map;
                if (current.get(keys[i]) == null) {
                    map = new LinkedHashMap();
                    current.put(keys[i], map);
                    current = map;
                } else {
                    map = (Map)current.get(keys[i]);
                    current = map;
                }
                ++i;
            }
            String name = keys[keys.length - 1];
            if (current.get(name) == null) {
                current.put(name, new ArrayList());
            }
            List value = (List)current.get(name);
            int position = Integer.valueOf(key.substring(index + 1, key.indexOf("]")));
            while (position >= value.size()) {
                value.add("");
            }
        }
    }

    private Properties convertToProperties(Environment profiles) {
        Properties map = new Properties();
        ArrayList sources = new ArrayList(profiles.getPropertySources());
        Collections.reverse(sources);
        for (PropertySource propertySource : sources) {
            Map value = propertySource.getSource();
            map.putAll((Map<?, ?>)value);
        }
        for (Map.Entry entry : map.entrySet()) {
            map.put(entry.getKey(), entry.getValue().toString());
        }
        return map;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public void setOverrides(Map<String, String> overrides) {
        this.overrides = overrides;
    }
}

