/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.config.Environment;
import org.springframework.cloud.config.PropertySource;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

public class NativeEnvironmentRepository
implements EnvironmentRepository {
    private Set<String> standardSources = new HashSet<String>(Arrays.asList("vcap", "systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams"));
    private ConfigurableEnvironment environment;

    public NativeEnvironmentRepository(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public Environment findOne(String application, String env, String label) {
        Environment result = new Environment(env, label);
        for (org.springframework.core.env.PropertySource source : this.environment.getPropertySources()) {
            String name = source.getName();
            if (this.standardSources.contains(name) || !(source instanceof MapPropertySource)) continue;
            result.add(new PropertySource(name, (Map)source.getSource()));
        }
        return result;
    }
}

