/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.ArrayList;
import java.util.Collections;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.Environment;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.cloud.config.server.NativeEnvironmentRepository;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.config.server.native")
public class SpringApplicationEnvironmentRepository
implements EnvironmentRepository {
    private String[] locations;
    private boolean failOnError = false;
    private static final String[] DEFAULT_LOCATIONS = new String[]{"classpath:/", "classpath:/config/", "file:./", "file:./config/"};

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public Environment findOne(String config, String profile, String label) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{PropertyPlaceholderAutoConfiguration.class});
        ConfigurableEnvironment environment = this.getEnvironment(profile);
        builder.environment(environment);
        builder.web(false).showBanner(false);
        String[] args = this.getArgs(config, label);
        builder.application().setListeners(Collections.singletonList(new ConfigFileApplicationListener()));
        ConfigurableApplicationContext context = builder.run(args);
        environment.getPropertySources().remove("profiles");
        try {
            Environment environment2 = new NativeEnvironmentRepository(environment).findOne(config, profile, label);
            return environment2;
        }
        finally {
            context.close();
        }
    }

    private ConfigurableEnvironment getEnvironment(String profile) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("profiles", Collections.singletonMap("spring.profiles.active", profile)));
        return environment;
    }

    private String[] getArgs(String config, String label) {
        ArrayList<String> list = new ArrayList<String>();
        if (!config.startsWith("application")) {
            config = "application," + config;
        }
        list.add("--spring.config.name=" + config);
        list.add("--spring.cloud.bootstrap.enabled=false");
        list.add("--encrypt.failOnError=" + this.failOnError);
        if (this.locations != null) {
            list.add("--spring.config.location=" + this.getLocations(this.locations, label));
        } else {
            list.add("--spring.config.location=" + this.getLocations(DEFAULT_LOCATIONS, label));
        }
        return list.toArray(new String[0]);
    }

    private String getLocations(String[] locations, String label) {
        String location;
        ArrayList<String> output = new ArrayList<String>();
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            location = stringArray[n2];
            output.add(location);
            ++n2;
        }
        stringArray = locations;
        n = locations.length;
        n2 = 0;
        while (n2 < n) {
            location = stringArray[n2];
            if (this.isDirectory(location) && StringUtils.hasText((String)label)) {
                output.add(String.valueOf(location) + label.trim() + "/");
            }
            ++n2;
        }
        return StringUtils.collectionToCommaDelimitedString(output);
    }

    public void setSearchLocations(String ... locations) {
        this.locations = locations;
        int i = 0;
        while (i < locations.length) {
            String location = locations[i];
            if (this.isDirectory(location) && !location.endsWith("/")) {
                location = String.valueOf(location) + "/";
            }
            locations[i] = location;
            ++i;
        }
    }

    private boolean isDirectory(String location) {
        return !location.endsWith(".properties") && !location.endsWith(".yml") && !location.endsWith(".yaml");
    }
}

