/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.config;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.context.config.BeanLifecycleDecorator;

public class StandardBeanLifecycleDecorator
implements BeanLifecycleDecorator<ReadWriteLock> {
    private final boolean proxyTargetClass;

    public StandardBeanLifecycleDecorator(boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
    }

    @Override
    public Object decorateBean(Object bean, BeanLifecycleDecorator.Context<ReadWriteLock> context) {
        if (context != null) {
            bean = this.getDisposalLockProxy(bean, context.getAuxiliary().readLock());
        }
        return bean;
    }

    @Override
    public BeanLifecycleDecorator.Context<ReadWriteLock> decorateDestructionCallback(final Runnable callback) {
        if (callback == null) {
            return null;
        }
        final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        return new BeanLifecycleDecorator.Context<ReadWriteLock>(new Runnable(){

            @Override
            public void run() {
                ReentrantReadWriteLock.WriteLock lock = readWriteLock.writeLock();
                lock.lock();
                try {
                    callback.run();
                }
                finally {
                    lock.unlock();
                }
            }
        }, readWriteLock);
    }

    private Object getDisposalLockProxy(Object bean, final Lock lock) {
        ProxyFactory factory = new ProxyFactory(bean);
        factory.setProxyTargetClass(this.proxyTargetClass);
        factory.addAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                lock.lock();
                try {
                    Object object = invocation.proceed();
                    return object;
                }
                finally {
                    lock.unlock();
                }
            }
        });
        return factory.getProxy();
    }
}

