/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.docs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.util.SpringCloudContractMetadata;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private final File rootPath;

    public Main(File rootPath) {
        this.rootPath = rootPath;
    }

    public static void main(String ... args) throws Exception {
        File rootPath = new File(args[0]);
        Main main = new Main(rootPath);
        main.produceJsonSchemaOfAYamlModel();
        main.produceAdocWithAllOfMetadataClasses();
    }

    void produceJsonSchemaOfAYamlModel() throws IOException {
        log.info("Generating schema...");
        String schemaString = this.generateJsonSchemaForClass(YamlContract.class);
        File schemaFile = new File(this.rootPath, "target/contract_schema.json");
        Files.write(schemaFile.toPath(), schemaString.getBytes(), new OpenOption[0]);
        log.info("Generated schema!");
    }

    private String generateJsonSchemaForClass(Class clazz) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(mapper);
        JsonSchema schema = schemaGen.generateSchema(clazz);
        return mapper.writeValueAsString((Object)schema);
    }

    void produceAdocWithAllOfMetadataClasses() throws Exception {
        log.info("Produce adoc with all metadata...");
        List<Class> metadata = this.metadataClasses();
        File doc = new File(this.rootPath, "target/metadata.adoc");
        StringBuilder sb = this.adocWithMetadata(metadata);
        Files.write(doc.toPath(), sb.toString().getBytes(), new OpenOption[0]);
        log.info("Produced adoc with all metadata!");
    }

    private StringBuilder adocWithMetadata(List<Class> metadata) throws Exception {
        YAMLMapper mapper = new YAMLMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        StringBuilder sb = new StringBuilder();
        for (Class metadatum : metadata) {
            SpringCloudContractMetadata newInstance = (SpringCloudContractMetadata)metadatum.newInstance();
            String description = newInstance.description();
            String key = newInstance.key();
            List<Class> additionalClasses = this.classesToLookAt(metadatum, newInstance);
            sb.append("[[metadata-").append(key).append("]]\n").append("##### Metadata `").append(key).append("`\n\n").append("* key: `").append(key).append("`").append("\n").append("* description:\n\n").append(description).append("\n\n").append("Example:\n\n").append("```yaml\n").append(mapper.writeValueAsString((Object)newInstance)).append("\n```\n\n").append("+++ <details><summary> +++\nClick here to expand the JSON schema:\n+++ </summary><div> +++\n").append("```json\n").append(this.generateJsonSchemaForClass(metadatum)).append("\n```\n").append("+++ </div></details> +++\n\n").append("If you are interested in learning more about the types and its properties, check out the following classes:\n\n").append(additionalClasses.stream().map(aClass -> "* `" + aClass.getName() + "`").collect(Collectors.joining("\n"))).append("\n\n");
        }
        return sb;
    }

    private List<Class> classesToLookAt(Class metadatum, SpringCloudContractMetadata newInstance) {
        ArrayList<Class> additionalClasses = new ArrayList<Class>();
        additionalClasses.add(metadatum);
        additionalClasses.addAll(newInstance.additionalClassesToLookAt());
        return additionalClasses;
    }

    private List<Class> metadataClasses() throws ClassNotFoundException {
        SimpleBeanDefinitionRegistry bdr = new SimpleBeanDefinitionRegistry();
        ClassPathBeanDefinitionScanner s = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)bdr, false);
        AssignableTypeFilter tf = new AssignableTypeFilter(SpringCloudContractMetadata.class);
        s.addIncludeFilter((TypeFilter)tf);
        String basePackage = "org.springframework.cloud.contract";
        s.scan(new String[]{basePackage});
        String[] beans = bdr.getBeanDefinitionNames();
        ArrayList<Class> metadata = new ArrayList<Class>();
        for (String bean : beans) {
            BeanDefinition beanDefinition = bdr.getBeanDefinition(bean);
            String beanClassName = beanDefinition.getBeanClassName();
            if (beanClassName != null && !beanClassName.contains(basePackage)) continue;
            metadata.add(Class.forName(beanClassName));
        }
        return metadata;
    }
}

