/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.WorkResult;
import org.springframework.cloud.contract.verifier.converter.ToYamlConverter;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.InitContractsTask;

class ContractsCopyTask
extends DefaultTask
implements GroovyObject {
    private static final String TASK_NAME = "copyContracts";
    private static final String CONTRACTS = "contracts";
    private static final String BACKUP = "original";
    @Nested
    private Config config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ContractsCopyTask() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void sync() {
        File contractsDirectory = ((Directory)this.config.getContractsDirectory().get()).getAsFile();
        this.throwExceptionWhenFailOnNoContracts(contractsDirectory);
        String antPattern = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.config.getIncludedRootFolderAntPattern().get()}, new String[]{"", "*.*"}));
        String slashSeparatedGroupId = DefaultGroovyMethods.toString((Object)((ProjectInternal)this.getProject()).getGroup()).replace(".", File.separator);
        String slashSeparatedAntPattern = antPattern.replace(slashSeparatedGroupId, DefaultGroovyMethods.toString((Object)((ProjectInternal)this.getProject()).getGroup()));
        File output = ((Directory)this.config.getCopiedContractsFolder().get()).getAsFile();
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{contractsDirectory, output, antPattern, slashSeparatedAntPattern}, new String[]{"Downloading and unpacking files from [", "()] to [", "]. The inclusion ant patterns are [", "] and [", "]"})));
        this.sync(contractsDirectory, antPattern, slashSeparatedAntPattern, DefaultTypeTransformation.booleanUnbox((Object)this.config.getExcludeBuildFolders().get()), output);
        Object object = this.config.getConvertToYaml().get();
        if (object == null ? false : (Boolean)object) {
            this.convertBackedUpDslsToYaml(contractsDirectory, antPattern, slashSeparatedAntPattern, output, DefaultTypeTransformation.booleanUnbox((Object)this.config.getExcludeBuildFolders().get()));
        }
    }

    public static Config fromExtension(ContractVerifierExtension extension, TaskProvider<InitContractsTask> initContractsTask, String root, Project project) {
        Config config = new Config();
        Property<Boolean> property = extension.getConvertToYaml();
        config.setConvertToYaml((Provider<Boolean>)property);
        Property<Boolean> property2 = extension.getExcludeBuildFolders();
        config.setExcludeBuildFolders((Provider<Boolean>)property2);
        Property<Boolean> property3 = extension.getFailOnNoContracts();
        config.setFailOnNoContracts((Provider<Boolean>)property3);
        public final class _fromExtension_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromExtension_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((InitContractsTask)((Object)it)).getConfig().getIncludedRootFolderAntPattern();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromExtension_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider = initContractsTask.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _fromExtension_closure1(ContractsCopyTask.class, ContractsCopyTask.class)), Transformer.class));
        config.setIncludedRootFolderAntPattern((Provider<String>)provider);
        public final class _fromExtension_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromExtension_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((InitContractsTask)((Object)it)).getConfig().getInitialisedContractsDirectory();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromExtension_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider2 = initContractsTask.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _fromExtension_closure2(ContractsCopyTask.class, ContractsCopyTask.class)), Transformer.class));
        config.setContractsDirectory((Provider<Directory>)provider2);
        DirectoryProperty directoryProperty = ContractsCopyTask.createTaskOutput(root, extension.getStubsOutputDir(), ContractsCopyTask.getCONTRACTS(), project);
        config.setCopiedContractsFolder(directoryProperty);
        DirectoryProperty directoryProperty2 = ContractsCopyTask.createTaskOutput(root, extension.getStubsOutputDir(), ContractsCopyTask.getBACKUP(), project);
        config.setBackupContractsFolder(directoryProperty2);
        return config;
    }

    private void convertBackedUpDslsToYaml(File file, String antPattern, String slashSeparatedAntPattern, File outputContractsFolder, boolean excludeBuildFolders) {
        this.sync(file, antPattern, slashSeparatedAntPattern, excludeBuildFolders, ((Directory)this.config.getBackupContractsFolder().get()).getAsFile());
        ToYamlConverter.replaceContractWithYaml((File)outputContractsFolder);
        this.getLogger().info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Replaced DSL files with their YAML representation at [", (Object)outputContractsFolder), (CharSequence)"]"));
    }

    /*
     * WARNING - void declaration
     */
    protected WorkResult sync(File file, String antPattern, String slashSeparatedAntPattern, boolean excludeBuildFolders, File outputContractsFolder) {
        void var3_3;
        void var2_2;
        Reference file2 = new Reference((Object)file);
        Reference antPattern2 = new Reference((Object)var2_2);
        Reference slashSeparatedAntPattern2 = new Reference((Object)var3_3);
        Reference excludeBuildFolders2 = new Reference((Object)excludeBuildFolders);
        Reference outputContractsFolder2 = new Reference((Object)outputContractsFolder);
        return ((ProjectInternal)this.getProject()).sync((Action)new Action<CopySpec>(this, file2, antPattern2, slashSeparatedAntPattern2, excludeBuildFolders2, outputContractsFolder2){
            public /* synthetic */ Reference outputContractsFolder;
            public /* synthetic */ Reference excludeBuildFolders;
            public /* synthetic */ Reference slashSeparatedAntPattern;
            public /* synthetic */ Reference antPattern;
            public /* synthetic */ Reference file;
            public /* synthetic */ ContractsCopyTask this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                ContractsCopyTask contractsCopyTask;
                this.this$0 = contractsCopyTask = p0;
                this.outputContractsFolder = reference5 = p5;
                this.excludeBuildFolders = reference4 = p4;
                this.slashSeparatedAntPattern = reference3 = p3;
                this.antPattern = reference2 = p2;
                this.file = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void execute(CopySpec spec) {
                public final class _execute_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference file;
                    private /* synthetic */ Reference antPattern;
                    private /* synthetic */ Reference slashSeparatedAntPattern;
                    private /* synthetic */ Reference excludeBuildFolders;
                    private /* synthetic */ Reference outputContractsFolder;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _execute_closure1(Object _outerInstance, Object _thisObject, Reference file, Reference antPattern, Reference slashSeparatedAntPattern, Reference excludeBuildFolders, Reference outputContractsFolder) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        this.file = reference5 = file;
                        this.antPattern = reference4 = antPattern;
                        this.slashSeparatedAntPattern = reference3 = slashSeparatedAntPattern;
                        this.excludeBuildFolders = reference2 = excludeBuildFolders;
                        this.outputContractsFolder = reference = outputContractsFolder;
                    }

                    public Object doCall(Object it) {
                        ((CopySpec)this.getDelegate()).from(new Object[]{this.file.get()});
                        ((CopySpec)this.getDelegate()).include(new String[]{ShortTypeHandling.castToString((Object)this.antPattern.get())});
                        ((CopySpec)this.getDelegate()).include(new String[]{ShortTypeHandling.castToString((Object)this.slashSeparatedAntPattern.get())});
                        if (DefaultTypeTransformation.booleanUnbox((Object)this.excludeBuildFolders.get())) {
                            ((CopySpec)this.getDelegate()).exclude(new String[]{"**/target/**", "**/build/**", "**/.mvn/**", "**/.gradle/**"});
                        }
                        return ((CopySpec)this.getDelegate()).into(this.outputContractsFolder.get());
                    }

                    public File getFile() {
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                    }

                    public String getAntPattern() {
                        return ShortTypeHandling.castToString((Object)this.antPattern.get());
                    }

                    public String getSlashSeparatedAntPattern() {
                        return ShortTypeHandling.castToString((Object)this.slashSeparatedAntPattern.get());
                    }

                    public boolean getExcludeBuildFolders() {
                        return DefaultTypeTransformation.booleanUnbox((Object)this.excludeBuildFolders.get());
                    }

                    public File getOutputContractsFolder() {
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.outputContractsFolder.get(), File.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.with((Object)spec, (Closure)new _execute_closure1(this, this, this.file, this.antPattern, this.slashSeparatedAntPattern, this.excludeBuildFolders, this.outputContractsFolder));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$3(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$3(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$3(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static DirectoryProperty createTaskOutput(String root, DirectoryProperty stubsOutputDir, String suffix, Project project) {
        void var3_3;
        void var2_2;
        Reference root2 = new Reference((Object)root);
        Reference suffix2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        public final class _createTaskOutput_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference root;
            private /* synthetic */ Reference suffix;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createTaskOutput_closure3(Object _outerInstance, Object _thisObject, Reference project, Reference root, Reference suffix) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.project = reference3 = project;
                this.root = reference2 = root;
                this.suffix = reference = suffix;
            }

            public Object doCall(Object it) {
                Directory dir = (Directory)ScriptBytecodeAdapter.castToType((Object)it, Directory.class);
                File output = ((Project)this.project.get()).file((Object)new GStringImpl(new Object[]{dir.getAsFile(), this.root.get(), this.suffix.get()}, new String[]{"", "/", "/", ""}));
                DirectoryProperty property = ((Project)this.project.get()).getObjects().directoryProperty();
                property.set(output);
                return property;
            }

            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            public String getRoot() {
                return ShortTypeHandling.castToString((Object)this.root.get());
            }

            public String getSuffix() {
                return ShortTypeHandling.castToString((Object)this.suffix.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTaskOutput_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider = stubsOutputDir.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _createTaskOutput_closure3(ContractsCopyTask.class, ContractsCopyTask.class, project2, root2, suffix2)), Transformer.class));
        DirectoryProperty property = ((Project)project2.get()).getObjects().directoryProperty();
        property.set(provider);
        return property;
    }

    private void throwExceptionWhenFailOnNoContracts(File file) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.config.getFailOnNoContracts().get()) && (!file.exists() || file.listFiles().length == 0)) {
            throw (Throwable)new GradleException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Contracts could not be found: [", (CharSequence)file.getAbsolutePath()), (CharSequence)"] .\nPlease make sure that the contracts were defined, or set the [failOnNoContracts] flag to [false]"));
        }
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ContractsCopyTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ContractsCopyTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ContractsCopyTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ContractsCopyTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static String getTASK_NAME() {
        return TASK_NAME;
    }

    @Generated
    public static String getCONTRACTS() {
        return CONTRACTS;
    }

    @Generated
    public static String getBACKUP() {
        return BACKUP;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config
    implements GroovyObject {
        @Input
        private Provider<Boolean> convertToYaml;
        @Input
        private Provider<Boolean> excludeBuildFolders;
        @Input
        private Provider<Boolean> failOnNoContracts;
        @Input
        private Provider<String> includedRootFolderAntPattern;
        @InputDirectory
        private Provider<Directory> contractsDirectory;
        @OutputDirectory
        private DirectoryProperty copiedContractsFolder;
        @Optional
        @OutputDirectory
        private DirectoryProperty backupContractsFolder;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Config() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, ContractsCopyTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Provider<Boolean> getConvertToYaml() {
            return this.convertToYaml;
        }

        @Generated
        public void setConvertToYaml(Provider<Boolean> provider) {
            this.convertToYaml = provider;
        }

        @Generated
        public Provider<Boolean> getExcludeBuildFolders() {
            return this.excludeBuildFolders;
        }

        @Generated
        public void setExcludeBuildFolders(Provider<Boolean> provider) {
            this.excludeBuildFolders = provider;
        }

        @Generated
        public Provider<Boolean> getFailOnNoContracts() {
            return this.failOnNoContracts;
        }

        @Generated
        public void setFailOnNoContracts(Provider<Boolean> provider) {
            this.failOnNoContracts = provider;
        }

        @Generated
        public Provider<String> getIncludedRootFolderAntPattern() {
            return this.includedRootFolderAntPattern;
        }

        @Generated
        public void setIncludedRootFolderAntPattern(Provider<String> provider) {
            this.includedRootFolderAntPattern = provider;
        }

        @Generated
        public Provider<Directory> getContractsDirectory() {
            return this.contractsDirectory;
        }

        @Generated
        public void setContractsDirectory(Provider<Directory> provider) {
            this.contractsDirectory = provider;
        }

        @Generated
        public DirectoryProperty getCopiedContractsFolder() {
            return this.copiedContractsFolder;
        }

        @Generated
        public void setCopiedContractsFolder(DirectoryProperty directoryProperty) {
            this.copiedContractsFolder = directoryProperty;
        }

        @Generated
        public DirectoryProperty getBackupContractsFolder() {
            return this.backupContractsFolder;
        }

        @Generated
        public void setBackupContractsFolder(DirectoryProperty directoryProperty) {
            this.backupContractsFolder = directoryProperty;
        }
    }
}

