/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.springframework.cloud.contract.spec.ContractVerifierException;
import org.springframework.cloud.contract.verifier.TestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.config.TestMode;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.ContractsCopyTask;
import org.springframework.cloud.contract.verifier.plugin.InitContractsTask;

public class GenerateServerTestsTask
extends DefaultTask
implements GroovyObject {
    private static final String TASK_NAME = "generateContractTests";
    @Nested
    private Config config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GenerateServerTestsTask() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void generate() {
        File generatedTestSources = ((Directory)this.config.getGeneratedTestSourcesDir().get()).getAsFile();
        File generatedTestResources = ((Directory)this.config.getGeneratedTestResourcesDir().get()).getAsFile();
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{generatedTestSources}, new String[]{"Generated test sources dir [", "]"})));
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{generatedTestResources}, new String[]{"Generated test resources dir [", "]"})));
        File contractsDslDir = ((Directory)this.config.getContractsDslDir().get()).getAsFile();
        String includedContracts = ShortTypeHandling.castToString((Object)this.config.getIncludedContracts().get());
        ((ProjectInternal)this.getProject()).getLogger().info("Spring Cloud Contract Verifier Plugin: Invoking test sources generation");
        ((ProjectInternal)this.getProject()).getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{contractsDslDir}, new String[]{"Contracts are unpacked to [", "]"})));
        ((ProjectInternal)this.getProject()).getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{includedContracts}, new String[]{"Included contracts are [", "]"})));
        try {
            List excludedFiles = (List)ScriptBytecodeAdapter.castToType((Object)this.config.getExcludedFiles().get(), List.class);
            List ignoredFiles = (List)ScriptBytecodeAdapter.castToType((Object)this.config.getIgnoredFiles().get(), List.class);
            List includedFiles = (List)ScriptBytecodeAdapter.castToType((Object)this.config.getIncludedFiles().get(), List.class);
            String[] imports = (String[])ScriptBytecodeAdapter.castToType((Object)((List)this.config.getImports().get()).toArray((Object[])ScriptBytecodeAdapter.castToType((Object)new String[0], Object[].class)), String[].class);
            String[] staticImports = (String[])ScriptBytecodeAdapter.castToType((Object)((List)this.config.getStaticImports().get()).toArray((Object[])ScriptBytecodeAdapter.castToType((Object)new String[0], Object[].class)), String[].class);
            ContractVerifierConfigProperties contractVerifierConfigProperties = new ContractVerifierConfigProperties();
            String string = includedContracts;
            contractVerifierConfigProperties.setIncludedContracts(string);
            File file = contractsDslDir;
            contractVerifierConfigProperties.setContractsDslDir(file);
            Object object = this.config.getNameSuffixForTests().getOrNull();
            contractVerifierConfigProperties.setNameSuffixForTests(ShortTypeHandling.castToString((Object)object));
            File file2 = generatedTestSources;
            contractVerifierConfigProperties.setGeneratedTestSourcesDir(file2);
            File file3 = generatedTestResources;
            contractVerifierConfigProperties.setGeneratedTestResourcesDir(file3);
            Object object2 = this.config.getBasePackageForTests().getOrNull();
            contractVerifierConfigProperties.setBasePackageForTests(ShortTypeHandling.castToString((Object)object2));
            Object object3 = this.config.getBaseClassForTests().getOrNull();
            contractVerifierConfigProperties.setBaseClassForTests(ShortTypeHandling.castToString((Object)object3));
            Object object4 = this.config.getPackageWithBaseClasses().getOrNull();
            contractVerifierConfigProperties.setPackageWithBaseClasses(ShortTypeHandling.castToString((Object)object4));
            List list = excludedFiles;
            contractVerifierConfigProperties.setExcludedFiles(list);
            List list2 = ignoredFiles;
            contractVerifierConfigProperties.setIgnoredFiles(list2);
            List list3 = includedFiles;
            contractVerifierConfigProperties.setIncludedFiles(list3);
            String[] stringArray = imports;
            contractVerifierConfigProperties.setImports(stringArray);
            String[] stringArray2 = staticImports;
            contractVerifierConfigProperties.setStaticImports(stringArray2);
            Object object5 = this.config.getTestMode().get();
            contractVerifierConfigProperties.setTestMode((TestMode)ShortTypeHandling.castToEnum((Object)object5, TestMode.class));
            Object object6 = this.config.getTestFramework().get();
            contractVerifierConfigProperties.setTestFramework((TestFramework)ShortTypeHandling.castToEnum((Object)object6, TestFramework.class));
            Object object7 = this.config.getBaseClassMappings().get();
            contractVerifierConfigProperties.setBaseClassMappings((Map)ScriptBytecodeAdapter.castToType((Object)object7, Map.class));
            Object object8 = this.config.getAssertJsonSize().get();
            contractVerifierConfigProperties.setAssertJsonSize((Boolean)ScriptBytecodeAdapter.castToType((Object)object8, Boolean.class));
            Object object9 = this.config.getFailOnInProgress().get();
            contractVerifierConfigProperties.setFailOnInProgress(DefaultTypeTransformation.booleanUnbox((Object)object9));
            TestGenerator generator = new TestGenerator(contractVerifierConfigProperties);
            int generatedClasses = generator.generate();
            ((ProjectInternal)this.getProject()).getLogger().info("Generated {} test classes", (Object)generatedClasses);
        }
        catch (ContractVerifierException e) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Spring Cloud Contract Verifier Plugin exception: ", ""})), (Throwable)e);
        }
    }

    public static Config fromExtension(ContractVerifierExtension extension, TaskProvider<InitContractsTask> initContractsTask, TaskProvider<ContractsCopyTask> copyContractsTask) {
        Config config = new Config();
        public final class _fromExtension_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromExtension_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ContractsCopyTask)((Object)it)).getConfig().getCopiedContractsFolder();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromExtension_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider = copyContractsTask.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _fromExtension_closure1(GenerateServerTestsTask.class, GenerateServerTestsTask.class)), Transformer.class));
        config.setContractsDslDir((Provider<Directory>)provider);
        public final class _fromExtension_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fromExtension_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((InitContractsTask)((Object)it)).getConfig().getIncludedContracts();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fromExtension_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Provider provider2 = initContractsTask.flatMap((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _fromExtension_closure2(GenerateServerTestsTask.class, GenerateServerTestsTask.class)), Transformer.class));
        config.setIncludedContracts((Provider<String>)provider2);
        Property<String> property = extension.getNameSuffixForTests();
        config.setNameSuffixForTests((Provider<String>)property);
        Property<String> property2 = extension.getBasePackageForTests();
        config.setBasePackageForTests((Provider<String>)property2);
        Property<String> property3 = extension.getBaseClassForTests();
        config.setBaseClassForTests((Provider<String>)property3);
        Property<String> property4 = extension.getPackageWithBaseClasses();
        config.setPackageWithBaseClasses((Provider<String>)property4);
        ListProperty<String> listProperty = extension.getExcludedFiles();
        config.setExcludedFiles(listProperty);
        ListProperty<String> listProperty2 = extension.getIgnoredFiles();
        config.setIgnoredFiles(listProperty2);
        ListProperty<String> listProperty3 = extension.getIncludedFiles();
        config.setIncludedFiles(listProperty3);
        ListProperty<String> listProperty4 = extension.getImports();
        config.setImports(listProperty4);
        ListProperty<String> listProperty5 = extension.getStaticImports();
        config.setStaticImports(listProperty5);
        Property<TestMode> property5 = extension.getTestMode();
        config.setTestMode((Provider<TestMode>)property5);
        Property<TestFramework> property6 = extension.getTestFramework();
        config.setTestFramework((Provider<TestFramework>)property6);
        MapProperty<String, String> mapProperty = extension.getBaseClassMappings();
        config.setBaseClassMappings(mapProperty);
        Property<Boolean> property7 = extension.getAssertJsonSize();
        config.setAssertJsonSize((Provider<Boolean>)property7);
        Property<Boolean> property8 = extension.getFailOnInProgress();
        config.setFailOnInProgress((Provider<Boolean>)property8);
        DirectoryProperty directoryProperty = extension.getGeneratedTestSourcesDir();
        config.setGeneratedTestSourcesDir(directoryProperty);
        DirectoryProperty directoryProperty2 = extension.getGeneratedTestResourcesDir();
        config.setGeneratedTestResourcesDir(directoryProperty2);
        return config;
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GenerateServerTestsTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GenerateServerTestsTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GenerateServerTestsTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GenerateServerTestsTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static String getTASK_NAME() {
        return TASK_NAME;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config
    implements GroovyObject {
        @InputDirectory
        private Provider<Directory> contractsDslDir;
        @Input
        private Provider<String> includedContracts;
        @Input
        @Optional
        private Provider<String> nameSuffixForTests;
        @Input
        @Optional
        private Provider<String> basePackageForTests;
        @Input
        @Optional
        private Provider<String> baseClassForTests;
        @Input
        @Optional
        private Provider<String> packageWithBaseClasses;
        @Input
        private ListProperty<String> excludedFiles;
        @Input
        private ListProperty<String> ignoredFiles;
        @Input
        private ListProperty<String> includedFiles;
        @Input
        private ListProperty<String> imports;
        @Input
        private ListProperty<String> staticImports;
        @Input
        private Provider<TestMode> testMode;
        @Input
        private Provider<TestFramework> testFramework;
        @Input
        private MapProperty<String, String> baseClassMappings;
        @Input
        private Provider<Boolean> assertJsonSize;
        @Input
        private Provider<Boolean> failOnInProgress;
        @OutputDirectory
        private DirectoryProperty generatedTestSourcesDir;
        @OutputDirectory
        private DirectoryProperty generatedTestResourcesDir;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Config() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, GenerateServerTestsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, GenerateServerTestsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateServerTestsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GenerateServerTestsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, GenerateServerTestsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, GenerateServerTestsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Provider<Directory> getContractsDslDir() {
            return this.contractsDslDir;
        }

        @Generated
        public void setContractsDslDir(Provider<Directory> provider) {
            this.contractsDslDir = provider;
        }

        @Generated
        public Provider<String> getIncludedContracts() {
            return this.includedContracts;
        }

        @Generated
        public void setIncludedContracts(Provider<String> provider) {
            this.includedContracts = provider;
        }

        @Generated
        public Provider<String> getNameSuffixForTests() {
            return this.nameSuffixForTests;
        }

        @Generated
        public void setNameSuffixForTests(Provider<String> provider) {
            this.nameSuffixForTests = provider;
        }

        @Generated
        public Provider<String> getBasePackageForTests() {
            return this.basePackageForTests;
        }

        @Generated
        public void setBasePackageForTests(Provider<String> provider) {
            this.basePackageForTests = provider;
        }

        @Generated
        public Provider<String> getBaseClassForTests() {
            return this.baseClassForTests;
        }

        @Generated
        public void setBaseClassForTests(Provider<String> provider) {
            this.baseClassForTests = provider;
        }

        @Generated
        public Provider<String> getPackageWithBaseClasses() {
            return this.packageWithBaseClasses;
        }

        @Generated
        public void setPackageWithBaseClasses(Provider<String> provider) {
            this.packageWithBaseClasses = provider;
        }

        @Generated
        public ListProperty<String> getExcludedFiles() {
            return this.excludedFiles;
        }

        @Generated
        public void setExcludedFiles(ListProperty<String> listProperty) {
            this.excludedFiles = listProperty;
        }

        @Generated
        public ListProperty<String> getIgnoredFiles() {
            return this.ignoredFiles;
        }

        @Generated
        public void setIgnoredFiles(ListProperty<String> listProperty) {
            this.ignoredFiles = listProperty;
        }

        @Generated
        public ListProperty<String> getIncludedFiles() {
            return this.includedFiles;
        }

        @Generated
        public void setIncludedFiles(ListProperty<String> listProperty) {
            this.includedFiles = listProperty;
        }

        @Generated
        public ListProperty<String> getImports() {
            return this.imports;
        }

        @Generated
        public void setImports(ListProperty<String> listProperty) {
            this.imports = listProperty;
        }

        @Generated
        public ListProperty<String> getStaticImports() {
            return this.staticImports;
        }

        @Generated
        public void setStaticImports(ListProperty<String> listProperty) {
            this.staticImports = listProperty;
        }

        @Generated
        public Provider<TestMode> getTestMode() {
            return this.testMode;
        }

        @Generated
        public void setTestMode(Provider<TestMode> provider) {
            this.testMode = provider;
        }

        @Generated
        public Provider<TestFramework> getTestFramework() {
            return this.testFramework;
        }

        @Generated
        public void setTestFramework(Provider<TestFramework> provider) {
            this.testFramework = provider;
        }

        @Generated
        public MapProperty<String, String> getBaseClassMappings() {
            return this.baseClassMappings;
        }

        @Generated
        public void setBaseClassMappings(MapProperty<String, String> mapProperty) {
            this.baseClassMappings = mapProperty;
        }

        @Generated
        public Provider<Boolean> getAssertJsonSize() {
            return this.assertJsonSize;
        }

        @Generated
        public void setAssertJsonSize(Provider<Boolean> provider) {
            this.assertJsonSize = provider;
        }

        @Generated
        public Provider<Boolean> getFailOnInProgress() {
            return this.failOnInProgress;
        }

        @Generated
        public void setFailOnInProgress(Provider<Boolean> provider) {
            this.failOnInProgress = provider;
        }

        @Generated
        public DirectoryProperty getGeneratedTestSourcesDir() {
            return this.generatedTestSourcesDir;
        }

        @Generated
        public void setGeneratedTestSourcesDir(DirectoryProperty directoryProperty) {
            this.generatedTestSourcesDir = directoryProperty;
        }

        @Generated
        public DirectoryProperty getGeneratedTestResourcesDir() {
            return this.generatedTestResourcesDir;
        }

        @Generated
        public void setGeneratedTestResourcesDir(DirectoryProperty directoryProperty) {
            this.generatedTestResourcesDir = directoryProperty;
        }
    }
}

