/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.KnownImmutable;
import groovy.transform.ToString;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.springframework.cloud.contract.stubrunner.ContractDownloader;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.StubRunnerOptionsFactory;
import org.springframework.util.StringUtils;

class GradleContractsDownloader
implements GroovyObject {
    private static final String LATEST_VERSION;
    private final Project project;
    private final Logger logger;
    protected static final Map<StubConfiguration, File> downloadedContract;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GradleContractsDownloader(Project project, Logger logger) {
        Logger logger2;
        Project project2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = project2 = project;
        this.logger = logger2 = logger;
    }

    public DownloadedData downloadAndUnpackContractsIfRequired(ContractVerifierExtension.Dependency contractDependency, ContractVerifierExtension.ContractRepository contractRepository, String contractsPath, StubRunnerProperties.StubsMode contractsMode, boolean deleteStubsAfterTest, Map<String, String> contractsProperties, boolean failOnNoContracts) {
        if (!GradleContractsDownloader.shouldDownloadContracts(contractDependency, contractRepository)) {
            return (DownloadedData)ScriptBytecodeAdapter.castToType(null, DownloadedData.class);
        }
        this.logger.info("Project has group id [{}], artifact id [{}]", this.project.getGroup(), (Object)this.project.getName());
        this.logger.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.project.getName()}, new String[]{"For project [", "] Download dependency is provided - will download contract jars"})));
        this.logger.info("Contract dependency [{}]", (Object)contractDependency);
        StubConfiguration configuration = this.stubConfiguration(contractDependency);
        this.logger.info("Got the following contract dependency to download [{}]", (Object)configuration);
        this.logger.info("The contract dependency is a changing one [{}] and cache download switch is set to [{}]", (Object)configuration.isVersionChanging(), contractRepository.getCacheDownloadedContracts().get());
        if (!configuration.isVersionChanging() && DefaultTypeTransformation.booleanUnbox((Object)contractRepository.getCacheDownloadedContracts().get())) {
            this.logger.info("Resolved a non changing version - will try to return the folder from a cache");
            File cachedFolder = (File)ScriptBytecodeAdapter.castToType((Object)downloadedContract.get(configuration), File.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)cachedFolder)) {
                this.logger.info("For project [{}] returning the cached location of the contracts", (Object)this.project.getName());
                ContractDownloader.InclusionProperties inclusionProperties = this.contractDownloader(configuration, contractRepository, contractsPath, contractsMode, deleteStubsAfterTest, contractsProperties, failOnNoContracts).createNewInclusionProperties(cachedFolder);
                return new DownloadedData(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"downloadedContracts", GradleContractsDownloader.contractsSubDirIfPresent(cachedFolder, this.logger), "inclusionProperties", inclusionProperties}));
            }
        }
        ContractDownloader contractDownloader = this.contractDownloader(configuration, contractRepository, contractsPath, contractsMode, deleteStubsAfterTest, contractsProperties, failOnNoContracts);
        File downloadedContracts = contractDownloader.unpackAndDownloadContracts();
        ContractDownloader.InclusionProperties inclusionProperties = contractDownloader.createNewInclusionProperties(downloadedContracts);
        downloadedContract.put(configuration, downloadedContracts);
        return new DownloadedData(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"downloadedContracts", GradleContractsDownloader.contractsSubDirIfPresent(downloadedContracts, this.logger), "inclusionProperties", inclusionProperties}));
    }

    private static File contractsSubDirIfPresent(File contractsDirectory, Logger logger) {
        File contracts = new File(contractsDirectory, "contracts");
        if (contracts.exists()) {
            File file;
            if (logger.isDebugEnabled()) {
                logger.debug(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Contracts folder found [", (Object)contracts), (CharSequence)"]"));
            }
            contractsDirectory = file = contracts;
        }
        return contractsDirectory;
    }

    StubConfiguration stubConfiguration(ContractVerifierExtension.Dependency contractDependency) {
        String groupId = ShortTypeHandling.castToString((Object)contractDependency.getGroupId().getOrNull());
        String artifactId = ShortTypeHandling.castToString((Object)contractDependency.getArtifactId().getOrNull());
        String version = StringUtils.hasText((String)ShortTypeHandling.castToString((Object)contractDependency.getVersion().getOrNull())) ? ShortTypeHandling.castToString((Object)contractDependency.getVersion().getOrNull()) : LATEST_VERSION;
        String classifier = ShortTypeHandling.castToString((Object)contractDependency.getClassifier().getOrNull());
        String stringNotation = ShortTypeHandling.castToString((Object)contractDependency.getStringNotation().getOrNull());
        if (StringUtils.hasText((String)stringNotation)) {
            StubConfiguration stubConfiguration = new StubConfiguration(stringNotation);
            return new StubConfiguration(stubConfiguration.getGroupId(), stubConfiguration.getArtifactId(), stubConfiguration.getVersion(), stubConfiguration.getClassifier());
        }
        return new StubConfiguration(groupId, artifactId, version, classifier);
    }

    protected ContractDownloader contractDownloader(StubConfiguration configuration, ContractVerifierExtension.ContractRepository contractRepository, String contractsPath, StubRunnerProperties.StubsMode contractsMode, boolean deleteStubsAfterTest, Map<String, String> contractsProperties, boolean failOnNoContracts) {
        return new ContractDownloader(this.stubDownloader(contractRepository, contractsMode, deleteStubsAfterTest, contractsProperties, failOnNoContracts), configuration, contractsPath, (String)ScriptBytecodeAdapter.asType((Object)this.project.getGroup(), String.class), this.project.getName(), (String)ScriptBytecodeAdapter.asType((Object)this.project.getVersion(), String.class));
    }

    protected StubDownloader stubDownloader(ContractVerifierExtension.ContractRepository contractRepository, StubRunnerProperties.StubsMode contractsMode, boolean deleteStubsAfterTest, Map<String, String> contractsProperties, boolean failOnNoContracts) {
        StubDownloaderBuilderProvider provider = new StubDownloaderBuilderProvider();
        return provider.get(StubRunnerOptionsFactory.createStubRunnerOptions(contractRepository, contractsMode, deleteStubsAfterTest, contractsProperties, failOnNoContracts), new StubDownloaderBuilder[0]);
    }

    private static boolean shouldDownloadContracts(ContractVerifierExtension.Dependency contractDependency, ContractVerifierExtension.ContractRepository contractRepository) {
        return StringUtils.hasText((String)ShortTypeHandling.castToString((Object)contractDependency.getArtifactId().getOrNull())) || StringUtils.hasText((String)ShortTypeHandling.castToString((Object)contractDependency.getStringNotation().getOrNull())) || StringUtils.hasText((String)ShortTypeHandling.castToString((Object)contractRepository.getRepositoryUrl().getOrNull()));
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GradleContractsDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GradleContractsDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GradleContractsDownloader.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GradleContractsDownloader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        LATEST_VERSION = string = "+";
        ConcurrentHashMap<StubConfiguration, File> concurrentHashMap = new ConcurrentHashMap<StubConfiguration, File>();
        downloadedContract = concurrentHashMap;
    }

    @ToString(cache=true, includeSuperProperties=true)
    @EqualsAndHashCode(cache=true)
    @KnownImmutable
    public static final class DownloadedData
    implements GroovyObject {
        private /* synthetic */ String $to$string;
        private /* synthetic */ int $hash$code;
        private final File downloadedContracts;
        private final ContractDownloader.InclusionProperties inclusionProperties;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public DownloadedData(File downloadedContracts, ContractDownloader.InclusionProperties inclusionProperties) {
            ContractDownloader.InclusionProperties inclusionProperties2;
            File file;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.downloadedContracts = file = downloadedContracts;
            this.inclusionProperties = inclusionProperties2 = inclusionProperties;
        }

        @Generated
        public DownloadedData(Map args) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (args == null) {
                Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                args = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)map, LinkedHashMap.class);
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
            if (args.get("downloadedContracts") == null) {
                Object var4_4 = null;
                this.downloadedContracts = (File)ScriptBytecodeAdapter.castToType(var4_4, File.class);
            } else {
                File file;
                this.downloadedContracts = file = (File)ScriptBytecodeAdapter.castToType(args.get("downloadedContracts"), File.class);
            }
            if (args.get("inclusionProperties") == null) {
                Object var6_6 = null;
                this.inclusionProperties = (ContractDownloader.InclusionProperties)ScriptBytecodeAdapter.castToType(var6_6, ContractDownloader.InclusionProperties.class);
            } else {
                ContractDownloader.InclusionProperties inclusionProperties;
                this.inclusionProperties = inclusionProperties = (ContractDownloader.InclusionProperties)ScriptBytecodeAdapter.castToType(args.get("inclusionProperties"), ContractDownloader.InclusionProperties.class);
            }
        }

        @Generated
        public DownloadedData() {
            this(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("org.springframework.cloud.contract.verifier.plugin.GradleContractsDownloader$DownloadedData(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getDownloadedContracts()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getInclusionProperties()));
            _result.append(")");
            if (this.$to$string == null) {
                String string;
                this.$to$string = string = _result.toString();
            }
            return this.$to$string;
        }

        @Generated
        public int hashCode() {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
                int n;
                int _result = HashCodeHelper.initHash();
                if (!(this.getDownloadedContracts() == this)) {
                    int n2;
                    _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)this.getDownloadedContracts());
                }
                if (!(this.getInclusionProperties() == this)) {
                    int n3;
                    _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)this.getInclusionProperties());
                }
                this.$hash$code = n = _result;
            }
            return this.$hash$code;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof DownloadedData;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadedData)) {
                return false;
            }
            DownloadedData otherTyped = (DownloadedData)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getDownloadedContracts(), (Object)otherTyped.getDownloadedContracts())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getInclusionProperties(), (Object)otherTyped.getInclusionProperties()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DownloadedData.class, GradleContractsDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DownloadedData.class, GradleContractsDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GradleContractsDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, GradleContractsDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadedData.class, GradleContractsDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DownloadedData.class, GradleContractsDownloader.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DownloadedData.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public final File getDownloadedContracts() {
            return this.downloadedContracts;
        }

        @Generated
        public final ContractDownloader.InclusionProperties getInclusionProperties() {
            return this.inclusionProperties;
        }
    }
}

