/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.GradleContractsDownloader;

class InitContractsTask
extends DefaultTask
implements GroovyObject {
    private static final String TASK_NAME = "initContracts";
    protected final GradleContractsDownloader contractDownloader;
    @Nested
    private Config config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public InitContractsTask() {
        MetaClass metaClass;
        GradleContractsDownloader gradleContractsDownloader;
        this.contractDownloader = gradleContractsDownloader = new GradleContractsDownloader(this.getProject(), this.getLogger());
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void initContracts() {
        GradleContractsDownloader.DownloadedData downloaded = this.contractDownloader.downloadAndUnpackContractsIfRequired(this.config.getContractDependency(), this.config.getContractRepository(), ShortTypeHandling.castToString((Object)this.config.getContractsPath().getOrNull()), (StubRunnerProperties.StubsMode)ShortTypeHandling.castToEnum((Object)this.config.getContractsMode().getOrNull(), StubRunnerProperties.StubsMode.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getDeleteStubsAfterTest().get()), (Map)ScriptBytecodeAdapter.castToType((Object)this.config.getContractsProperties().get(), Map.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getFailOnNoContracts().get()));
        if (downloaded != null) {
            this.config.getIncludedContracts().set((Object)downloaded.getInclusionProperties().getIncludedContracts());
            this.config.getIncludedRootFolderAntPattern().set((Object)downloaded.getInclusionProperties().getIncludedRootFolderAntPattern());
            this.config.getInitialisedContractsDirectory().set(downloaded.getDownloadedContracts());
        }
        this.getLogger().info("For project [{}] will use contracts provided in the folder [{}]", (Object)((ProjectInternal)this.getProject()).getName(), this.config.getInitialisedContractsDirectory().get());
    }

    public static Config fromExtension(ContractVerifierExtension extension, Project project) {
        DirectoryProperty initialisedContractsDirectory = project.getObjects().directoryProperty();
        initialisedContractsDirectory.set((Provider)extension.getContractsDslDir());
        Config config = new Config();
        ContractVerifierExtension.Dependency dependency = extension.getContractDependency();
        config.setContractDependency(dependency);
        ContractVerifierExtension.ContractRepository contractRepository = extension.getContractRepository();
        config.setContractRepository(contractRepository);
        Property<StubRunnerProperties.StubsMode> property = extension.getContractsMode();
        config.setContractsMode(property);
        Property<Boolean> property2 = extension.getDeleteStubsAfterTest();
        config.setDeleteStubsAfterTest(property2);
        Property<Boolean> property3 = extension.getFailOnNoContracts();
        config.setFailOnNoContracts(property3);
        MapProperty<String, String> mapProperty = extension.getContractsProperties();
        config.setContractsProperties(mapProperty);
        Property<String> property4 = extension.getContractsPath();
        config.setContractsPath(property4);
        Property property5 = project.getObjects().property(String.class).convention((Object)".*");
        config.setIncludedContracts((Property<String>)property5);
        Property property6 = project.getObjects().property(String.class).convention((Object)"**/");
        config.setIncludedRootFolderAntPattern((Property<String>)property6);
        DirectoryProperty directoryProperty = initialisedContractsDirectory;
        config.setInitialisedContractsDirectory(directoryProperty);
        return config;
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(InitContractsTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, InitContractsTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(InitContractsTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != InitContractsTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static String getTASK_NAME() {
        return TASK_NAME;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config
    implements GroovyObject {
        @Nested
        @Optional
        private ContractVerifierExtension.Dependency contractDependency;
        @Nested
        @Optional
        private ContractVerifierExtension.ContractRepository contractRepository;
        @Input
        @Optional
        private Property<StubRunnerProperties.StubsMode> contractsMode;
        @Input
        private Property<Boolean> deleteStubsAfterTest;
        @Input
        private Property<Boolean> failOnNoContracts;
        @Input
        private MapProperty<String, String> contractsProperties;
        @Input
        @Optional
        private Property<String> contractsPath;
        @org.gradle.api.tasks.Internal
        private Property<String> includedContracts;
        @org.gradle.api.tasks.Internal
        private Property<String> includedRootFolderAntPattern;
        @OutputDirectory
        private DirectoryProperty initialisedContractsDirectory;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Config() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, InitContractsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, InitContractsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, InitContractsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, InitContractsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, InitContractsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, InitContractsTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public ContractVerifierExtension.Dependency getContractDependency() {
            return this.contractDependency;
        }

        @Generated
        public void setContractDependency(ContractVerifierExtension.Dependency dependency) {
            this.contractDependency = dependency;
        }

        @Generated
        public ContractVerifierExtension.ContractRepository getContractRepository() {
            return this.contractRepository;
        }

        @Generated
        public void setContractRepository(ContractVerifierExtension.ContractRepository contractRepository) {
            this.contractRepository = contractRepository;
        }

        @Generated
        public Property<StubRunnerProperties.StubsMode> getContractsMode() {
            return this.contractsMode;
        }

        @Generated
        public void setContractsMode(Property<StubRunnerProperties.StubsMode> property) {
            this.contractsMode = property;
        }

        @Generated
        public Property<Boolean> getDeleteStubsAfterTest() {
            return this.deleteStubsAfterTest;
        }

        @Generated
        public void setDeleteStubsAfterTest(Property<Boolean> property) {
            this.deleteStubsAfterTest = property;
        }

        @Generated
        public Property<Boolean> getFailOnNoContracts() {
            return this.failOnNoContracts;
        }

        @Generated
        public void setFailOnNoContracts(Property<Boolean> property) {
            this.failOnNoContracts = property;
        }

        @Generated
        public MapProperty<String, String> getContractsProperties() {
            return this.contractsProperties;
        }

        @Generated
        public void setContractsProperties(MapProperty<String, String> mapProperty) {
            this.contractsProperties = mapProperty;
        }

        @Generated
        public Property<String> getContractsPath() {
            return this.contractsPath;
        }

        @Generated
        public void setContractsPath(Property<String> property) {
            this.contractsPath = property;
        }

        @Generated
        public Property<String> getIncludedContracts() {
            return this.includedContracts;
        }

        @Generated
        public void setIncludedContracts(Property<String> property) {
            this.includedContracts = property;
        }

        @Generated
        public Property<String> getIncludedRootFolderAntPattern() {
            return this.includedRootFolderAntPattern;
        }

        @Generated
        public void setIncludedRootFolderAntPattern(Property<String> property) {
            this.includedRootFolderAntPattern = property;
        }

        @Generated
        public DirectoryProperty getInitialisedContractsDirectory() {
            return this.initialisedContractsDirectory;
        }

        @Generated
        public void setInitialisedContractsDirectory(DirectoryProperty directoryProperty) {
            this.initialisedContractsDirectory = directoryProperty;
        }
    }
}

