/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.springframework.cloud.contract.stubrunner.ContractProjectUpdater;
import org.springframework.cloud.contract.stubrunner.ScmStubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.StubRunnerOptionsFactory;

public class PublishStubsToScmTask
extends DefaultTask
implements GroovyObject {
    private static final String TASK_NAME = "publishStubsToScm";
    @Nested
    private Config config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public PublishStubsToScmTask() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void publishStubsToScm() {
        if (!this.shouldRun()) {
            return;
        }
        String projectName = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)DefaultGroovyMethods.toString((Object)((ProjectInternal)this.getProject()).getGroup()), (CharSequence)":"), (CharSequence)((ProjectInternal)this.getProject()).getName().toString()), (CharSequence)":"), (CharSequence)DefaultGroovyMethods.toString((Object)this.getProject().getVersion()));
        ((ProjectInternal)this.getProject()).getLogger().info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Pushing Stubs to SCM for project [", (CharSequence)projectName), (CharSequence)"]"));
        StubRunnerOptions stubRunnerOptions = StubRunnerOptionsFactory.createStubRunnerOptions(this.config.getContractRepository(), (StubRunnerProperties.StubsMode)ShortTypeHandling.castToEnum((Object)this.config.getContractsMode().getOrNull(), StubRunnerProperties.StubsMode.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getDeleteStubsAfterTest().get()), (Map)ScriptBytecodeAdapter.castToType((Object)this.config.getContractsProperties().get(), Map.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getFailOnNoContracts().get()));
        new ContractProjectUpdater(stubRunnerOptions).updateContractProject(projectName, ((Directory)this.config.getStubsOutputDir().get()).getAsFile().toPath());
    }

    public static Config fromExtension(ContractVerifierExtension extension) {
        Config config = new Config();
        ContractVerifierExtension.ContractRepository contractRepository = extension.getContractRepository();
        config.setContractRepository(contractRepository);
        Property<StubRunnerProperties.StubsMode> property = extension.getContractsMode();
        config.setContractsMode((Provider<StubRunnerProperties.StubsMode>)property);
        Property<Boolean> property2 = extension.getFailOnNoContracts();
        config.setFailOnNoContracts((Provider<Boolean>)property2);
        Property<Boolean> property3 = extension.getDeleteStubsAfterTest();
        config.setDeleteStubsAfterTest((Provider<Boolean>)property3);
        MapProperty<String, String> mapProperty = extension.getContractsProperties();
        config.setContractsProperties(mapProperty);
        DirectoryProperty directoryProperty = extension.getStubsOutputDir();
        config.setStubsOutputDir(directoryProperty);
        return config;
    }

    private boolean shouldRun() {
        Object object = this.config.getContractRepository().getRepositoryUrl().getOrNull();
        String string = ShortTypeHandling.castToString((Object)object);
        String contractRepoUrl = DefaultTypeTransformation.booleanUnbox((Object)object) ? string : "";
        if (!DefaultTypeTransformation.booleanUnbox((Object)contractRepoUrl) || !ScmStubDownloaderBuilder.isProtocolAccepted((String)contractRepoUrl)) {
            ((ProjectInternal)this.getProject()).getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{contractRepoUrl}, new String[]{"Skipping pushing stubs to scm since your contracts repository URL [", "] doesn't match any of the accepted protocols for SCM stub downloader"})));
            return false;
        }
        return true;
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PublishStubsToScmTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PublishStubsToScmTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PublishStubsToScmTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PublishStubsToScmTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static String getTASK_NAME() {
        return TASK_NAME;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config
    implements GroovyObject {
        @Nested
        @Optional
        private ContractVerifierExtension.ContractRepository contractRepository;
        @Input
        @Optional
        private Provider<StubRunnerProperties.StubsMode> contractsMode;
        @Input
        private Provider<Boolean> deleteStubsAfterTest;
        @Input
        private Provider<Boolean> failOnNoContracts;
        @Input
        private MapProperty<String, String> contractsProperties;
        @OutputDirectory
        private DirectoryProperty stubsOutputDir;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Config() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public ContractVerifierExtension.ContractRepository getContractRepository() {
            return this.contractRepository;
        }

        @Generated
        public void setContractRepository(ContractVerifierExtension.ContractRepository contractRepository) {
            this.contractRepository = contractRepository;
        }

        @Generated
        public Provider<StubRunnerProperties.StubsMode> getContractsMode() {
            return this.contractsMode;
        }

        @Generated
        public void setContractsMode(Provider<StubRunnerProperties.StubsMode> provider) {
            this.contractsMode = provider;
        }

        @Generated
        public Provider<Boolean> getDeleteStubsAfterTest() {
            return this.deleteStubsAfterTest;
        }

        @Generated
        public void setDeleteStubsAfterTest(Provider<Boolean> provider) {
            this.deleteStubsAfterTest = provider;
        }

        @Generated
        public Provider<Boolean> getFailOnNoContracts() {
            return this.failOnNoContracts;
        }

        @Generated
        public void setFailOnNoContracts(Provider<Boolean> provider) {
            this.failOnNoContracts = provider;
        }

        @Generated
        public MapProperty<String, String> getContractsProperties() {
            return this.contractsProperties;
        }

        @Generated
        public void setContractsProperties(MapProperty<String, String> mapProperty) {
            this.contractsProperties = mapProperty;
        }

        @Generated
        public DirectoryProperty getStubsOutputDir() {
            return this.stubsOutputDir;
        }

        @Generated
        public void setStubsOutputDir(DirectoryProperty directoryProperty) {
            this.stubsOutputDir = directoryProperty;
        }
    }
}

