/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.test.docker.junit5;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.springframework.cloud.dataflow.common.test.docker.compose.DockerComposeRule;
import org.springframework.cloud.dataflow.common.test.docker.junit5.DockerCompose;
import org.springframework.cloud.dataflow.common.test.docker.junit5.DockerComposeCluster;
import org.springframework.cloud.dataflow.common.test.docker.junit5.DockerComposeInfo;
import org.springframework.cloud.dataflow.common.test.docker.junit5.DockerComposeManager;

public class DockerComposeExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{DockerComposeExtension.class});

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        DockerComposeManager dockerComposeManager = DockerComposeExtension.getDockerComposeManager(extensionContext);
        Class testClass = extensionContext.getRequiredTestClass();
        String classKey = extensionContext.getRequiredTestClass().getSimpleName();
        List dockerComposeAnnotations = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)testClass, DockerCompose.class);
        for (DockerCompose dockerComposeAnnotation : dockerComposeAnnotations) {
            DockerComposeManager.DockerComposeData dockerComposeData = new DockerComposeManager.DockerComposeData(dockerComposeAnnotation.id(), dockerComposeAnnotation.locations(), dockerComposeAnnotation.services(), dockerComposeAnnotation.log(), dockerComposeAnnotation.start(), dockerComposeAnnotation.order());
            dockerComposeManager.addClassDockerComposeData(classKey, dockerComposeData);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        DockerComposeManager dockerComposeManager = DockerComposeExtension.getDockerComposeManager(context);
        Method testMethod = context.getRequiredTestMethod();
        String classKey = context.getRequiredTestClass().getSimpleName();
        String methodKey = context.getRequiredTestMethod().getName();
        List dockerComposeAnnotations = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)testMethod, DockerCompose.class);
        for (DockerCompose dockerComposeAnnotation : dockerComposeAnnotations) {
            DockerComposeManager.DockerComposeData dockerComposeData = new DockerComposeManager.DockerComposeData(dockerComposeAnnotation.id(), dockerComposeAnnotation.locations(), dockerComposeAnnotation.services(), dockerComposeAnnotation.log(), dockerComposeAnnotation.start(), dockerComposeAnnotation.order());
            dockerComposeManager.addMethodDockerComposeData(classKey, methodKey, dockerComposeData);
        }
        dockerComposeManager.build(classKey, methodKey);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        DockerComposeManager dockerComposeManager = DockerComposeExtension.getDockerComposeManager(context);
        String classKey = context.getRequiredTestClass().getSimpleName();
        String methodKey = context.getRequiredTestMethod().getName();
        dockerComposeManager.stop(classKey, methodKey);
    }

    public void afterAll(ExtensionContext context) throws Exception {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == DockerComposeInfo.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        DockerComposeManager dockerComposeManager = DockerComposeExtension.getDockerComposeManager(extensionContext);
        return new DefaultDockerComposeInfo(dockerComposeManager);
    }

    private static DockerComposeManager getDockerComposeManager(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = DockerComposeExtension.getStore(context);
        return (DockerComposeManager)store.getOrComputeIfAbsent((Object)testClass, key -> new DockerComposeManager(), DockerComposeManager.class);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    private static class DefaultDockerComposeCluster
    implements DockerComposeCluster {
        private final DockerComposeManager dockerComposeManager;
        private final String id;

        public DefaultDockerComposeCluster(DockerComposeManager dockerComposeManager, String id) {
            this.dockerComposeManager = dockerComposeManager;
            this.id = id;
        }

        @Override
        public DockerComposeRule getRule() {
            return this.dockerComposeManager.getRule(this.id);
        }

        @Override
        public void start() {
            this.dockerComposeManager.startId(this.id);
        }

        @Override
        public void stop() {
            this.dockerComposeManager.stopId(this.id);
        }
    }

    private static class DefaultDockerComposeInfo
    implements DockerComposeInfo {
        private final DockerComposeManager dockerComposeManager;

        public DefaultDockerComposeInfo(DockerComposeManager dockerComposeManager) {
            this.dockerComposeManager = dockerComposeManager;
        }

        @Override
        public DockerComposeCluster id(String id) {
            return new DefaultDockerComposeCluster(this.dockerComposeManager, id);
        }
    }
}

