/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.common.test.docker.junit5;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.common.test.docker.compose.DockerComposeRule;
import org.springframework.cloud.dataflow.common.test.docker.compose.configuration.DockerComposeFiles;
import org.springframework.cloud.dataflow.common.test.docker.compose.connection.waiting.HealthChecks;

public class DockerComposeManager {
    private final Map<String, DockerComposeRule> rules = new HashMap<String, DockerComposeRule>();
    private final Map<String, List<DockerComposeData>> classKeys = new HashMap<String, List<DockerComposeData>>();
    private final Map<String, List<DockerComposeData>> methodKeys = new HashMap<String, List<DockerComposeData>>();

    public void addClassDockerComposeData(String classKey, DockerComposeData dockerComposeData) {
        String key = dockerComposeData.id + "$" + classKey;
        this.classKeys.putIfAbsent(key, new ArrayList());
        this.classKeys.get(key).add(dockerComposeData);
    }

    public void addMethodDockerComposeData(String classKey, String methodKey, DockerComposeData dockerComposeData) {
        String key = dockerComposeData.id + "$" + classKey;
        if (this.classKeys.containsKey(key)) {
            this.classKeys.get(key).add(dockerComposeData);
        } else {
            key = dockerComposeData.id + "$" + classKey + methodKey;
            this.methodKeys.putIfAbsent(key, new ArrayList());
            this.methodKeys.get(key).add(dockerComposeData);
        }
    }

    public DockerComposeRule getRule(String id) {
        for (Map.Entry<String, DockerComposeRule> e : this.rules.entrySet()) {
            String idMatch = e.getKey().substring(0, e.getKey().indexOf("$"));
            if (!id.equals(idMatch)) continue;
            return e.getValue();
        }
        throw new IllegalArgumentException("Id " + id + " not found");
    }

    public void build(String classKey, String methodKey) {
        Object builder;
        String log;
        Integer order;
        boolean start;
        ArrayList<String> services;
        ArrayList<String> locations;
        String key;
        ArrayList<OrderingWrapper> toStart = new ArrayList<OrderingWrapper>();
        for (Map.Entry<String, List<DockerComposeData>> e : this.classKeys.entrySet()) {
            key = e.getKey();
            locations = new ArrayList<String>();
            services = new ArrayList<String>();
            start = true;
            order = Integer.MAX_VALUE;
            log = "";
            for (DockerComposeData dockerComposeData : e.getValue()) {
                locations.addAll(Arrays.asList(dockerComposeData.getLocations()));
                services.addAll(Arrays.asList(dockerComposeData.getServices()));
                if (!dockerComposeData.isStart()) {
                    start = false;
                }
                if (dockerComposeData.getOrder() < order) {
                    order = dockerComposeData.getOrder();
                }
                if (dockerComposeData.getLog() == null || dockerComposeData.getLog().length() <= 0) continue;
                log = dockerComposeData.getLog();
            }
            builder = DockerComposeRule.builder();
            builder.files(DockerComposeFiles.from((String[])locations.toArray(new String[0])));
            for (String service : services) {
                builder.waitingForService(service, HealthChecks.toHaveAllPortsOpen());
            }
            builder.saveLogsTo("build/test-docker-logs/" + log + classKey + "-" + methodKey);
            DockerComposeRule dockerComposeRule = builder.build();
            this.rules.put(key, dockerComposeRule);
            if (!start) continue;
            toStart.add(new OrderingWrapper(order, dockerComposeRule));
        }
        for (Map.Entry<String, List<DockerComposeData>> e : this.methodKeys.entrySet()) {
            key = e.getKey();
            locations = new ArrayList();
            services = new ArrayList();
            start = true;
            order = Integer.MAX_VALUE;
            log = "";
            for (DockerComposeData dockerComposeData : e.getValue()) {
                locations.addAll(Arrays.asList(dockerComposeData.getLocations()));
                services.addAll(Arrays.asList(dockerComposeData.getServices()));
                if (!dockerComposeData.isStart()) {
                    start = false;
                }
                if (dockerComposeData.getOrder() < order) {
                    order = dockerComposeData.getOrder();
                }
                if (dockerComposeData.getLog() == null || dockerComposeData.getLog().length() <= 0) continue;
                log = dockerComposeData.getLog();
            }
            builder = DockerComposeRule.builder();
            builder.files(DockerComposeFiles.from((String[])locations.toArray(new String[0])));
            for (String service : services) {
                builder.waitingForService(service, HealthChecks.toHaveAllPortsOpen());
            }
            builder.saveLogsTo("build/test-docker-logs/" + log + classKey + "-" + methodKey);
            DockerComposeRule dockerComposeRule = builder.build();
            this.rules.put(key, dockerComposeRule);
            if (!start) continue;
            toStart.add(new OrderingWrapper(order, dockerComposeRule));
        }
        Collections.sort(toStart);
        for (OrderingWrapper w : toStart) {
            try {
                w.getRule().before();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stop(String classKey, String methodKey) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, DockerComposeRule> e : this.rules.entrySet()) {
            String idMatch = e.getKey().substring(e.getKey().indexOf("$") + 1, e.getKey().length());
            if (idMatch.equals(classKey)) {
                toRemove.add(e.getKey());
            }
            if (!idMatch.equals(classKey + methodKey)) continue;
            toRemove.add(e.getKey());
        }
        for (String remove : toRemove) {
            DockerComposeRule rule = this.rules.remove(remove);
            if (rule == null) continue;
            rule.after();
        }
        this.classKeys.clear();
        this.methodKeys.clear();
    }

    public void startId(String id) {
        DockerComposeRule rule = null;
        for (Map.Entry<String, DockerComposeRule> e : this.rules.entrySet()) {
            String idMatch = e.getKey().substring(0, e.getKey().indexOf("$"));
            if (!id.equals(idMatch)) continue;
            rule = e.getValue();
        }
        if (rule != null) {
            try {
                rule.before();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopId(String id) {
        DockerComposeRule rule = null;
        for (Map.Entry<String, DockerComposeRule> e : this.rules.entrySet()) {
            String idMatch = e.getKey().substring(0, e.getKey().indexOf("$"));
            if (!id.equals(idMatch)) continue;
            rule = e.getValue();
        }
        if (rule != null) {
            rule.after();
        }
    }

    private static class OrderingWrapper
    implements Comparable<OrderingWrapper> {
        Integer order;
        DockerComposeRule rule;

        public OrderingWrapper(Integer order, DockerComposeRule rule) {
            this.order = order;
            this.rule = rule;
        }

        public Integer getOrder() {
            return this.order;
        }

        public DockerComposeRule getRule() {
            return this.rule;
        }

        @Override
        public int compareTo(OrderingWrapper o) {
            return this.getOrder().compareTo(o.getOrder());
        }
    }

    public static class DockerComposeData {
        private final String id;
        private final boolean start;
        private final String[] locations;
        private final String[] services;
        private final String log;
        private final int order;

        public DockerComposeData(String id, String[] locations, String[] services, String log, boolean start, int order) {
            this.id = id;
            this.locations = locations;
            this.services = services;
            this.log = log;
            this.start = start;
            this.order = order;
        }

        public String[] getLocations() {
            return this.locations;
        }

        public String[] getServices() {
            return this.services;
        }

        public String getLog() {
            return this.log;
        }

        public String getId() {
            return this.id;
        }

        public boolean isStart() {
            return this.start;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

