/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepositoryJsonBuilder;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.cloud.dataflow.configuration.metadata.AppMetadataResolutionException;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.configuration.metadata.BootClassLoaderFactory;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImageMetadataResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BootApplicationConfigurationMetadataResolver
extends ApplicationConfigurationMetadataResolver {
    private static final Logger logger = LoggerFactory.getLogger(BootApplicationConfigurationMetadataResolver.class);
    private static final String CONFIGURATION_METADATA_PATTERN = "classpath*:/META-INF/spring-configuration-metadata.json";
    private static final String WHITELIST_LEGACY_PROPERTIES = "classpath*:/META-INF/spring-configuration-metadata-whitelist.properties";
    private static final String WHITELIST_PROPERTIES = "classpath*:/META-INF/dataflow-configuration-metadata-whitelist.properties";
    private static final String CONFIGURATION_PROPERTIES_CLASSES = "configuration-properties.classes";
    private static final String CONFIGURATION_PROPERTIES_NAMES = "configuration-properties.names";
    private static final String CONTAINER_IMAGE_CONFIGURATION_METADATA_LABEL_NAME = "org.springframework.cloud.dataflow.spring-configuration-metadata.json";
    private final Set<String> globalWhiteListedProperties = new HashSet<String>();
    private final Set<String> globalWhiteListedClasses = new HashSet<String>();
    private final ClassLoader parent;
    private ContainerImageMetadataResolver containerImageMetadataResolver;

    public BootApplicationConfigurationMetadataResolver(ContainerImageMetadataResolver containerImageMetadataResolver) {
        this(null, containerImageMetadataResolver);
    }

    public BootApplicationConfigurationMetadataResolver(ClassLoader parent, ContainerImageMetadataResolver containerImageMetadataResolver) {
        this.parent = parent;
        this.containerImageMetadataResolver = containerImageMetadataResolver;
        JarFile.registerUrlProtocolHandler();
        try {
            Resource[] globalLegacyResources = new PathMatchingResourcePatternResolver(ApplicationConfigurationMetadataResolver.class.getClassLoader()).getResources(WHITELIST_LEGACY_PROPERTIES);
            Resource[] globalResources = new PathMatchingResourcePatternResolver(ApplicationConfigurationMetadataResolver.class.getClassLoader()).getResources(WHITELIST_PROPERTIES);
            this.loadWhiteLists(BootApplicationConfigurationMetadataResolver.concatArrays(globalLegacyResources, globalResources), this.globalWhiteListedClasses, this.globalWhiteListedProperties);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading global white list of configuration properties", e);
        }
    }

    private static Resource[] concatArrays(Resource[] ... arrays) {
        return (Resource[])Arrays.stream(arrays).flatMap(Arrays::stream).toArray(Resource[]::new);
    }

    @Override
    public List<ConfigurationMetadataProperty> listProperties(Resource app, boolean exhaustive) {
        try {
            if (app != null) {
                if (this.isDockerSchema(app.getURI())) {
                    return this.resolvePropertiesFromContainerImage(app.getURI());
                }
                Archive archive = this.resolveAsArchive(app);
                return this.listProperties(archive, exhaustive);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve properties for resource:" + app, (Throwable)e);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private boolean isDockerSchema(URI uri) {
        return uri != null && uri.getScheme() != null && uri.getScheme().contains("docker");
    }

    private List<ConfigurationMetadataProperty> resolvePropertiesFromContainerImage(URI imageUri) {
        String imageName = imageUri.getSchemeSpecificPart();
        Map<String, String> labels = this.containerImageMetadataResolver.getImageLabels(imageName);
        if (CollectionUtils.isEmpty(labels)) {
            return Collections.emptyList();
        }
        String encodedMetadata = labels.get(CONTAINER_IMAGE_CONFIGURATION_METADATA_LABEL_NAME);
        if (!StringUtils.hasText((String)encodedMetadata)) {
            return Collections.emptyList();
        }
        try {
            String metadataJson = StringEscapeUtils.unescapeJson((String)encodedMetadata);
            ConfigurationMetadataRepository configurationMetadataRepository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource((InputStream)new ByteArrayInputStream(metadataJson.getBytes())).build();
            List<ConfigurationMetadataProperty> result = configurationMetadataRepository.getAllProperties().entrySet().stream().map(e -> (ConfigurationMetadataProperty)e.getValue()).collect(Collectors.toList());
            return result;
        }
        catch (Exception e2) {
            throw new AppMetadataResolutionException("Invalid Metadata for " + imageName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ConfigurationMetadataProperty> listProperties(Archive archive, boolean exhaustive) {
        try (URLClassLoader moduleClassLoader = new BootClassLoaderFactory(archive, this.parent).createClassLoader();){
            ArrayList<ConfigurationMetadataProperty> result = new ArrayList<ConfigurationMetadataProperty>();
            PathMatchingResourcePatternResolver moduleResourceLoader = new PathMatchingResourcePatternResolver((ClassLoader)moduleClassLoader);
            HashSet<String> whiteListedClasses = new HashSet<String>(this.globalWhiteListedClasses);
            HashSet<String> whiteListedProperties = new HashSet<String>(this.globalWhiteListedProperties);
            Resource[] whitelistLegacyDescriptors = moduleResourceLoader.getResources(WHITELIST_LEGACY_PROPERTIES);
            Resource[] whitelistDescriptors = moduleResourceLoader.getResources(WHITELIST_PROPERTIES);
            this.loadWhiteLists(BootApplicationConfigurationMetadataResolver.concatArrays(whitelistLegacyDescriptors, whitelistDescriptors), whiteListedClasses, whiteListedProperties);
            ConfigurationMetadataRepositoryJsonBuilder builder = ConfigurationMetadataRepositoryJsonBuilder.create();
            for (Resource r : moduleResourceLoader.getResources(CONFIGURATION_METADATA_PATTERN)) {
                builder.withJsonResource(r.getInputStream());
            }
            for (ConfigurationMetadataGroup group : builder.build().getAllGroups().values()) {
                if (exhaustive || this.isWhiteListed(group, whiteListedClasses)) {
                    for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                        if (this.isDeprecatedError(property)) continue;
                        result.add(property);
                    }
                    continue;
                }
                if ("_ROOT_GROUP_".equals(group.getId())) {
                    for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                        if (!this.isWhiteListed(property, whiteListedProperties) || this.isDeprecatedError(property)) continue;
                        result.add(property);
                    }
                    continue;
                }
                for (ConfigurationMetadataProperty property : group.getProperties().values()) {
                    if (!this.isWhiteListed(property, whiteListedProperties) || this.isDeprecatedError(property)) continue;
                    result.add(property);
                }
            }
            ArrayList<ConfigurationMetadataProperty> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception trying to list configuration properties for application " + archive, e);
        }
    }

    @Override
    public URLClassLoader createAppClassLoader(Resource app) {
        try {
            return new BootClassLoaderFactory(this.resolveAsArchive(app), this.parent).createClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve application resource: " + app.getDescription(), e);
        }
    }

    private Archive resolveAsArchive(Resource app) throws IOException {
        File moduleFile = app.getFile();
        return moduleFile.isDirectory() ? new ExplodedArchive(moduleFile) : new JarFileArchive(moduleFile);
    }

    private void loadWhiteLists(Resource[] resources, Collection<String> classes, Collection<String> names) throws IOException {
        for (Resource resource : resources) {
            Properties properties = new Properties();
            properties.load(resource.getInputStream());
            classes.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_CLASSES), (String)",", (String)" ")));
            names.addAll(Arrays.asList(StringUtils.delimitedListToStringArray((String)properties.getProperty(CONFIGURATION_PROPERTIES_NAMES), (String)",", (String)" ")));
        }
    }

    private boolean isWhiteListed(ConfigurationMetadataProperty property, Collection<String> properties) {
        return properties.contains(property.getId());
    }

    private boolean isDeprecatedError(ConfigurationMetadataProperty property) {
        return property.getDeprecation() != null && property.getDeprecation().getLevel() == Deprecation.Level.ERROR;
    }

    private boolean isWhiteListed(ConfigurationMetadataGroup group, Collection<String> classes) {
        Set sourceTypes = group.getSources().keySet();
        return !sourceTypes.isEmpty() && classes.containsAll(sourceTypes);
    }
}

