/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata.container;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContainerImage {
    private static final Pattern NAMESPACE_COMPONENT_PATTERN = Pattern.compile("[a-z0-9]+(?:[._\\-][a-z0-9]+)*");
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("[a-z0-9\\-_]{2,255}");
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-zA-Z0-9_][a-zA-Z0-9\\-_.]{0,127}$");
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");
    private static final Pattern IP_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern PORT_PATTERN = Pattern.compile("^([0-9]{1,4}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$");
    private String hostname;
    private String port;
    private String repositoryNamespace;
    private String repositoryName;
    private String repositoryTag;

    public String getRegistryHost() {
        return this.hostname + (StringUtils.hasText((String)this.port) ? ":" + this.port : "");
    }

    public String getRepository() {
        String ns = StringUtils.hasText((String)this.repositoryNamespace) ? this.repositoryNamespace + "/" : "";
        return ns + this.repositoryName;
    }

    public String getCanonicalName() {
        return this.getRegistryHost() + "/" + this.getRepository() + ":" + this.getRepositoryTag();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        Assert.isTrue((HOSTNAME_PATTERN.matcher(hostname).matches() || IP_PATTERN.matcher(hostname).matches() ? 1 : 0) != 0, (String)("Invalid registry hostname: " + hostname));
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        Assert.isTrue((boolean)PORT_PATTERN.matcher(port).matches(), (String)("Invalid registry port: " + port));
        this.port = port;
    }

    public String getRepositoryNamespace() {
        return this.repositoryNamespace;
    }

    public void setRepositoryNamespace(String repositoryNamespace) {
        this.repositoryNamespace = repositoryNamespace;
    }

    public void setNamespaceComponents(String[] namespaceComponents) {
        if (namespaceComponents != null && namespaceComponents.length > 0) {
            Stream.of(namespaceComponents).forEach(pathComponent -> Assert.isTrue((boolean)NAMESPACE_COMPONENT_PATTERN.matcher((CharSequence)pathComponent).matches(), (String)("Invalid namespace path component: " + pathComponent)));
            this.setRepositoryNamespace(String.join((CharSequence)"/", namespaceComponents));
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        Assert.isTrue((boolean)REPOSITORY_NAME_PATTERN.matcher(repositoryName).matches(), (String)("Invalid repository name: " + repositoryName));
        this.repositoryName = repositoryName;
    }

    public String getRepositoryTag() {
        return this.repositoryTag;
    }

    public void setRepositoryTag(String repositoryTag) {
        Assert.isTrue((boolean)TAG_PATTERN.matcher(repositoryTag).matches(), (String)("Invalid repository tag: " + repositoryTag));
        this.repositoryTag = repositoryTag;
    }

    public String toString() {
        return "ContainerImage{ host='" + this.hostname + "', port='" + this.port + "', namespace='" + this.repositoryNamespace + "', name='" + this.repositoryName + "', tag='" + this.repositoryTag + "'}";
    }
}

