/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.configuration.metadata.container.authorization;

import java.util.Map;
import org.springframework.cloud.dataflow.configuration.metadata.container.ContainerImage;
import org.springframework.cloud.dataflow.configuration.metadata.container.RegistryConfiguration;
import org.springframework.cloud.dataflow.configuration.metadata.container.authorization.RegistryAuthorizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DockerOAuth2RegistryAuthorizer
implements RegistryAuthorizer {
    public static final String DEFAULT_DOCKER_REGISTRY_AUTH_URI = "https://auth.docker.io/token?service=registry.docker.io&scope=repository:{repository}:pull&offline_token=1&client_id=shell";
    public static final String TOKEN_KEY = "token";
    public static final String DOCKER_REGISTRY_AUTH_URI_KEY = "registryAuthUri";
    private final RestTemplate restTemplate;
    private final RestTemplate noSslVerificationContainerRestTemplate;

    public DockerOAuth2RegistryAuthorizer(RestTemplate restTemplate, RestTemplate noSslVerificationContainerRestTemplate) {
        this.restTemplate = restTemplate;
        this.noSslVerificationContainerRestTemplate = noSslVerificationContainerRestTemplate;
    }

    @Override
    public RegistryConfiguration.AuthorizationType getType() {
        return RegistryConfiguration.AuthorizationType.dockeroauth2;
    }

    @Override
    public HttpHeaders getAuthorizationHeaders(ContainerImage containerImage, RegistryConfiguration registryConfiguration) {
        Assert.isTrue((registryConfiguration.getAuthorizationType() == this.getType() ? 1 : 0) != 0, (String)("Incorrect authorization type: " + (Object)((Object)registryConfiguration.getAuthorizationType())));
        Assert.notNull((Object)containerImage, (String)"Valid containerImageName is required!");
        String imageRepository = containerImage.getRepository();
        Assert.hasText((String)imageRepository, (String)"Valid repository name (e.g. namespace/repository-name without the tag) is required for the authorization");
        HttpHeaders requestHttpHeaders = new HttpHeaders();
        if (StringUtils.hasText((String)registryConfiguration.getUser()) && StringUtils.hasText((String)registryConfiguration.getSecret())) {
            requestHttpHeaders.setBasicAuth(registryConfiguration.getUser(), registryConfiguration.getSecret());
        }
        String registryAuthUri = registryConfiguration.getExtra().containsKey(DOCKER_REGISTRY_AUTH_URI_KEY) ? registryConfiguration.getExtra().get(DOCKER_REGISTRY_AUTH_URI_KEY) : DEFAULT_DOCKER_REGISTRY_AUTH_URI;
        UriComponentsBuilder.newInstance();
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)registryAuthUri).build().expand(new Object[]{imageRepository});
        ResponseEntity authorization = this.getRestTemplate(registryConfiguration).exchange(uriComponents.toUri(), HttpMethod.GET, new HttpEntity((MultiValueMap)requestHttpHeaders), Map.class);
        Map authorizationBody = (Map)authorization.getBody();
        HttpHeaders responseHttpHeaders = new HttpHeaders();
        responseHttpHeaders.setBearerAuth((String)authorizationBody.get(TOKEN_KEY));
        return responseHttpHeaders;
    }

    private RestTemplate getRestTemplate(RegistryConfiguration registryConfiguration) {
        return registryConfiguration.isDisableSslVerification() ? this.noSslVerificationContainerRestTemplate : this.restTemplate;
    }
}

