/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.module;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.cloud.dataflow.core.ModuleDeploymentId;
import org.springframework.cloud.dataflow.module.DeploymentState;
import org.springframework.cloud.dataflow.module.ModuleInstanceStatus;

public class ModuleStatus {
    private final ModuleDeploymentId moduleDeploymentId;
    private final Map<String, ModuleInstanceStatus> instances = new HashMap<String, ModuleInstanceStatus>();

    protected ModuleStatus(ModuleDeploymentId moduleDeploymentId) {
        this.moduleDeploymentId = moduleDeploymentId;
    }

    public ModuleDeploymentId getModuleDeploymentId() {
        return this.moduleDeploymentId;
    }

    public DeploymentState getState() {
        HashSet<DeploymentState> states = new HashSet<DeploymentState>();
        for (Map.Entry<String, ModuleInstanceStatus> entry : this.instances.entrySet()) {
            states.add(entry.getValue().getState());
        }
        if (states.size() == 0) {
            return DeploymentState.undeployed;
        }
        if (states.size() == 1) {
            return (DeploymentState)((Object)states.iterator().next());
        }
        if (states.contains((Object)DeploymentState.error)) {
            return DeploymentState.error;
        }
        if (states.contains((Object)DeploymentState.deploying)) {
            return DeploymentState.deploying;
        }
        if (states.contains((Object)DeploymentState.deployed) || states.contains((Object)DeploymentState.partial)) {
            return DeploymentState.partial;
        }
        if (states.contains((Object)DeploymentState.failed)) {
            return DeploymentState.failed;
        }
        return DeploymentState.partial;
    }

    public Map<String, ModuleInstanceStatus> getInstances() {
        return Collections.unmodifiableMap(this.instances);
    }

    private void addInstance(String id, ModuleInstanceStatus status) {
        this.instances.put(id, status);
    }

    public static Builder of(ModuleDeploymentId key) {
        return new Builder(key);
    }

    public static class Builder {
        private final ModuleStatus status;

        private Builder(ModuleDeploymentId key) {
            this.status = new ModuleStatus(key);
        }

        public Builder with(ModuleInstanceStatus instance) {
            this.status.addInstance(instance.getId(), instance);
            return this;
        }

        public ModuleStatus build() {
            return this.status;
        }
    }
}

