/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import org.springframework.cloud.dataflow.rest.client.JobOperations;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionResource;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionThinResource;
import org.springframework.cloud.dataflow.rest.resource.JobInstanceResource;
import org.springframework.cloud.dataflow.rest.resource.StepExecutionProgressInfoResource;
import org.springframework.cloud.dataflow.rest.resource.StepExecutionResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class JobTemplate
implements JobOperations {
    private static final String EXECUTIONS_RELATION = "jobs/thinexecutions";
    private static final String EXECUTION_RELATION = "jobs/executions/execution";
    private static final String EXECUTION_RELATION_BY_NAME = "jobs/thinexecutions/name";
    private static final String INSTANCE_RELATION = "jobs/instances/instance";
    private static final String INSTANCE_RELATION_BY_NAME = "jobs/instances/name";
    private static final String STEP_EXECUTION_RELATION_BY_ID = "jobs/executions/execution/steps";
    private static final String STEP_EXECUTION_PROGRESS_RELATION_BY_ID = "jobs/executions/execution/steps/step/progress";
    private final RestTemplate restTemplate;
    private final Link executionsLink;
    private final Link executionLink;
    private final Link executionByNameLink;
    private final Link instanceLink;
    private final Link instanceByNameLink;
    private final Link stepExecutionsLink;
    private final Link stepExecutionProgressLink;
    private final Link stepExecutionLink;

    JobTemplate(RestTemplate restTemplate, ResourceSupport resources) {
        Assert.notNull((Object)resources, (String)"URI Resources must not be be null");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        Assert.notNull((Object)resources.getLink(EXECUTIONS_RELATION), (String)"Executions relation is required");
        Assert.notNull((Object)resources.getLink(EXECUTION_RELATION), (String)"Execution relation is required");
        Assert.notNull((Object)resources.getLink(EXECUTION_RELATION_BY_NAME), (String)"Execution by name relation is required");
        Assert.notNull((Object)resources.getLink(INSTANCE_RELATION), (String)"Instance relation is required");
        Assert.notNull((Object)resources.getLink(INSTANCE_RELATION_BY_NAME), (String)"Instance by name relation is required");
        Assert.notNull((Object)resources.getLink(STEP_EXECUTION_RELATION_BY_ID), (String)"Step Execution by id relation is required");
        Assert.notNull((Object)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID), (String)"Step Execution Progress by id relation is required");
        Assert.notNull((Object)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID), (String)"Step Execution View by id relation is required");
        this.restTemplate = restTemplate;
        this.executionsLink = resources.getLink(EXECUTIONS_RELATION);
        this.executionLink = resources.getLink(EXECUTION_RELATION);
        this.executionByNameLink = resources.getLink(EXECUTION_RELATION_BY_NAME);
        this.instanceLink = resources.getLink(INSTANCE_RELATION);
        this.instanceByNameLink = resources.getLink(INSTANCE_RELATION_BY_NAME);
        this.stepExecutionsLink = resources.getLink(STEP_EXECUTION_RELATION_BY_ID);
        this.stepExecutionProgressLink = resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID);
        this.stepExecutionLink = resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID);
    }

    @Override
    public PagedResources<JobExecutionResource> executionList() {
        String uriTemplate = this.executionsLink.getHref().toString();
        uriTemplate = uriTemplate + "?size=2000";
        return (PagedResources)this.restTemplate.getForObject(uriTemplate, JobExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public PagedResources<JobExecutionThinResource> executionThinList() {
        String uriTemplate = this.executionsLink.getHref().toString();
        uriTemplate = uriTemplate + "?size=2000";
        return (PagedResources)this.restTemplate.getForObject(uriTemplate, JobExecutionThinResource.Page.class, new Object[0]);
    }

    @Override
    public PagedResources<JobInstanceResource> instanceList(String jobName) {
        return (PagedResources)this.restTemplate.getForObject(this.instanceByNameLink.expand(new Object[]{jobName}).getHref(), JobInstanceResource.Page.class, new Object[0]);
    }

    @Override
    public PagedResources<JobExecutionThinResource> executionThinListByJobName(String jobName) {
        return (PagedResources)this.restTemplate.getForObject(this.executionByNameLink.expand(new Object[]{jobName}).getHref(), JobExecutionThinResource.Page.class, new Object[0]);
    }

    @Override
    public PagedResources<JobExecutionResource> executionListByJobName(String jobName) {
        return (PagedResources)this.restTemplate.getForObject(this.executionByNameLink.expand(new Object[]{jobName}).getHref(), JobExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public JobExecutionResource jobExecution(long id) {
        return (JobExecutionResource)this.restTemplate.getForObject(this.executionLink.expand(new Object[]{id}).getHref(), JobExecutionResource.class, new Object[0]);
    }

    @Override
    public JobInstanceResource jobInstance(long id) {
        return (JobInstanceResource)this.restTemplate.getForObject(this.instanceLink.expand(new Object[]{id}).getHref(), JobInstanceResource.class, new Object[0]);
    }

    @Override
    public PagedResources<StepExecutionResource> stepExecutionList(long jobExecutionId) {
        return (PagedResources)this.restTemplate.getForObject(this.stepExecutionsLink.expand(new Object[]{jobExecutionId}).getHref(), StepExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public StepExecutionProgressInfoResource stepExecutionProgress(long jobExecutionId, long stepExecutionId) {
        return (StepExecutionProgressInfoResource)this.restTemplate.getForObject(this.stepExecutionProgressLink.expand(new Object[]{jobExecutionId, stepExecutionId}).getHref(), StepExecutionProgressInfoResource.class, new Object[0]);
    }
}

