/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import org.springframework.cloud.dataflow.rest.resource.AppInstanceStatusResource;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.StringUtils;

public class AppStatusResource
extends RepresentationModel<AppStatusResource> {
    public static final String NO_INSTANCES = "no-instances";
    private String deploymentId;
    private String state;
    private CollectionModel<AppInstanceStatusResource> instances;

    private AppStatusResource() {
    }

    public AppStatusResource(String deploymentId, String state) {
        this.deploymentId = deploymentId;
        this.state = state;
    }

    public String getName() {
        if (this.instances != null && this.instances.iterator().hasNext()) {
            AppInstanceStatusResource instance = (AppInstanceStatusResource)((Object)this.instances.iterator().next());
            return instance != null && instance.getAttributes() != null && StringUtils.hasText((String)instance.getAttributes().get("skipper.application.name")) ? instance.getAttributes().get("skipper.application.name") : NO_INSTANCES;
        }
        return NO_INSTANCES;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public CollectionModel<AppInstanceStatusResource> getInstances() {
        return this.instances;
    }

    public void setInstances(CollectionModel<AppInstanceStatusResource> instances) {
        this.instances = instances;
    }

    public static class Page
    extends PagedModel<AppStatusResource> {
    }
}

