/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import org.springframework.batch.item.ExecutionContext;

public class ExecutionContextDeserializer
extends JsonDeserializer<ExecutionContext> {
    public ExecutionContext deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        ExecutionContext executionContext = new ExecutionContext();
        boolean dirty = node.get("dirty").asBoolean();
        for (JsonNode valueNode : node.get("values")) {
            JsonNode nodeValue = (JsonNode)((Map.Entry)valueNode.fields().next()).getValue();
            String nodeKey = (String)((Map.Entry)valueNode.fields().next()).getKey();
            if (nodeValue.isNumber() && !nodeValue.isFloatingPointNumber() && nodeValue.canConvertToInt()) {
                executionContext.putInt(nodeKey, nodeValue.asInt());
                continue;
            }
            if (nodeValue.isNumber() && !nodeValue.isFloatingPointNumber() && nodeValue.canConvertToLong()) {
                executionContext.putLong(nodeKey, nodeValue.asLong());
                continue;
            }
            if (nodeValue.isFloatingPointNumber()) {
                executionContext.putDouble(nodeKey, nodeValue.asDouble());
                continue;
            }
            if (nodeValue.isBoolean()) {
                executionContext.putString(nodeKey, String.valueOf(nodeValue.asBoolean()));
                continue;
            }
            if (nodeValue.isTextual()) {
                executionContext.putString(nodeKey, nodeValue.asText());
                continue;
            }
            executionContext.put(nodeKey, (Object)nodeValue.toString());
        }
        if (!dirty && executionContext.isDirty()) {
            executionContext.clearDirtyFlag();
        }
        return executionContext;
    }
}

