/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.scheduler.launcher.configuration;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.scheduler.launcher.configuration.SchedulerTaskLauncher;
import org.springframework.cloud.dataflow.scheduler.launcher.configuration.SchedulerTaskLauncherException;
import org.springframework.cloud.dataflow.scheduler.launcher.configuration.SchedulerTaskLauncherProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={SchedulerTaskLauncherProperties.class})
public class LauncherConfiguration {
    @Bean
    public SchedulerTaskLauncher launchRequestConsumer(SchedulerTaskLauncherProperties schedulerTaskLauncherProperties, TaskOperations taskOperations, Environment environment) {
        return new SchedulerTaskLauncher(taskOperations, schedulerTaskLauncherProperties, environment);
    }

    @Bean
    public TaskOperations getTaskOperations(SchedulerTaskLauncherProperties schedulerTaskLauncherProperties, DataFlowOperations dataFlowOperations) {
        try {
            URI dataFlowUri = new URI(schedulerTaskLauncherProperties.getDataflowServerUri());
            if (dataFlowOperations.taskOperations() == null) {
                throw new SchedulerTaskLauncherException("The task operations are not enabled in the Spring Cloud Data Flow server");
            }
            return dataFlowOperations.taskOperations();
        }
        catch (URISyntaxException e) {
            throw new SchedulerTaskLauncherException("Invalid Spring Cloud Data Flow URI", (Throwable)e);
        }
    }

    @Bean
    public CommandLineRunner commandLineRunner(SchedulerTaskLauncher schedulerTaskLauncher) {
        return args -> schedulerTaskLauncher.launchTask(args);
    }
}

