/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.util;

import java.nio.file.Path;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.jupiter.api.extension.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.common.test.docker.compose.configuration.DockerComposeFiles;
import org.springframework.cloud.dataflow.common.test.docker.compose.configuration.ProjectName;
import org.springframework.cloud.dataflow.common.test.docker.compose.connection.DockerMachine;
import org.springframework.cloud.dataflow.common.test.docker.compose.connection.waiting.HealthChecks;
import org.springframework.cloud.dataflow.common.test.docker.junit5.LegacyDockerComposeExtension;
import org.springframework.cloud.dataflow.integration.test.util.DockerComposeFactoryProperties;
import org.springframework.cloud.dataflow.integration.test.util.ResourceExtractor;

public class DockerComposeFactory {
    private static final Logger logger = LoggerFactory.getLogger(DockerComposeFactory.class);
    public static final String DEFAULT_TASK_APPS_URI = "https://dataflow.spring.io/task-maven-latest&force=true";
    public static final String KAFKA_MAVEN_STREAM_APPS_URI = "https://dataflow.spring.io/kafka-maven-latest&force=true";
    public static final String RABBITMQ_MAVEN_STREAM_APPS_URI = "https://dataflow.spring.io/rabbitmq-maven-latest&force=true";
    public static final String KAFKA_DOCKER_STREAM_APPS_URI = "https://dataflow.spring.io/kafka-docker-latest&force=true";
    private static final String DEFAULT_STREAM_APPS_URI = "https://dataflow.spring.io/kafka-maven-latest&force=true";
    private static final String[] DEFAULT_DOCKER_COMPOSE_PATHS = new String[]{"../src/docker-compose/docker-compose.yml", "../src/docker-compose/docker-compose-prometheus.yml"};
    private static boolean isDood = DockerComposeFactoryProperties.getBoolean("test.docker.compose.dood", false);
    private static DockerMachine dockerMachine = DockerMachine.localMachine().withAdditionalEnvironmentVariable("COMPOSE_HTTP_TIMEOUT", "300").withAdditionalEnvironmentVariable("PLATFORM_TYPE", "local").withAdditionalEnvironmentVariable("DATAFLOW_URI", DockerComposeFactoryProperties.get("test.docker.compose.dataflow.uri", "http://dataflow-server:9393")).withAdditionalEnvironmentVariable("BP_JVM_VERSION", DockerComposeFactoryProperties.get("test.docker.compose.bp.jvm.version.version", "")).withAdditionalEnvironmentVariable("DATAFLOW_VERSION", DockerComposeFactoryProperties.get("test.docker.compose.dataflow.version", "")).withAdditionalEnvironmentVariable("SKIPPER_URI", DockerComposeFactoryProperties.get("test.docker.compose.skipper.uri", "http://skipper-server:7577")).withAdditionalEnvironmentVariable("SKIPPER_VERSION", DockerComposeFactoryProperties.get("test.docker.compose.skipper.version", "")).withAdditionalEnvironmentVariable("STREAM_APPS_URI", DockerComposeFactoryProperties.get("test.docker.compose.stream.apps.uri", isDood ? "https://dataflow.spring.io/kafka-docker-latest&force=true" : "https://dataflow.spring.io/kafka-maven-latest&force=true")).withAdditionalEnvironmentVariable("TASK_APPS_URI", DockerComposeFactoryProperties.get("test.docker.compose.task.apps.uri", isDood ? "https://dataflow.spring.io/task-docker-latest" : "https://dataflow.spring.io/task-maven-latest&force=true")).withAdditionalEnvironmentVariable("DOCKER_DELETE_CONTAINER_ON_EXIT", "" + DockerComposeFactoryProperties.getBoolean("test.docker.compose.docker.delete.container.on.exit", true)).withAdditionalEnvironmentVariable("METADATA_DEFAULT_DOCKERHUB_USER", DockerComposeFactoryProperties.get("METADATA_DEFAULT_DOCKERHUB_USER", "")).withAdditionalEnvironmentVariable("METADATA_DEFAULT_DOCKERHUB_PASSWORD", DockerComposeFactoryProperties.get("METADATA_DEFAULT_DOCKERHUB_PASSWORD", "")).withAdditionalEnvironmentVariable("COMPOSE_PROJECT_NAME", "scdf").withAdditionalEnvironmentVariable("CR_AZURE_USER", DockerComposeFactoryProperties.get("CR_AZURE_USER", "")).withAdditionalEnvironmentVariable("CR_AZURE_PASS", DockerComposeFactoryProperties.get("CR_AZURE_PASS", "")).withAdditionalEnvironmentVariable("CR_GITHUB_USER", DockerComposeFactoryProperties.get("CR_GITHUB_USER", "")).withAdditionalEnvironmentVariable("CR_GITHUB_PASS", DockerComposeFactoryProperties.get("CR_GITHUB_PASS", "")).withAdditionalEnvironmentVariable("CR_HARBOR_USER", DockerComposeFactoryProperties.get("CR_HARBOR_USER", "")).withAdditionalEnvironmentVariable("CR_HARBOR_PASS", DockerComposeFactoryProperties.get("CR_HARBOR_PASS", "")).build();

    private static String[] addDockerComposeToPath(String[] dockerComposePaths, String additionalDockerCompose) {
        if (Stream.of(dockerComposePaths).anyMatch(p -> p.contains(additionalDockerCompose))) {
            return dockerComposePaths;
        }
        String[] dockerComposePathsEx = new String[dockerComposePaths.length + 1];
        System.arraycopy(dockerComposePaths, 0, dockerComposePathsEx, 0, dockerComposePaths.length);
        dockerComposePathsEx[dockerComposePaths.length] = additionalDockerCompose;
        return dockerComposePathsEx;
    }

    public static Extension startDockerCompose(Path tempFolder) {
        if (DockerComposeFactoryProperties.isDockerComposeDisabled()) {
            return context -> logger.debug("Docker Compose installation is disabled!");
        }
        logger.info("Docker Compose based Integration Tests. \nFollowing environment variables or properties can be used to configure the testing fixture: \n - TEST_DOCKER_COMPOSE_PATHS (test.docker.compose.paths) configures the list of docker-compose files. \n - TEST_DOCKER_COMPOSE_DATAFLOW_VERSION (test.docker.compose.dataflow.version) sets the Data Flow version used for testing. \n - TEST_DOCKER_COMPOSE_SKIPPER_VERSION (test.docker.compose.skipper.version) sets the Skipper version used for testing. \n - TEST_DOCKER_COMPOSE_STREAM_APPS_URI (test.docker.compose.stream.apps.uri) version of the Streaming apps used for testing. \n - TEST_DOCKER_COMPOSE_TASK_APPS_URI (test.docker.compose.taks.apps.uri)  sets the Tasks apps version used for testing. \n - TEST_DOCKER_COMPOSE_PULLONSTARTUP (test.docker.compose.pullOnStartup) enable/disable pulling latest docker images from the Docker Hub. \n");
        logger.info("{} = {}", (Object)"test.docker.compose.dataflow.version", (Object)DockerComposeFactoryProperties.get("test.docker.compose.dataflow.version", "default version set in ../src/docker-compose/docker-compose.yml"));
        logger.info("{} = {}", (Object)"test.docker.compose.skipper.version", (Object)DockerComposeFactoryProperties.get("test.docker.compose.skipper.version", "default version set in ../src/docker-compose/docker-compose.yml"));
        logger.info("{} = {}", (Object)"test.docker.compose.pullOnStartup", (Object)DockerComposeFactoryProperties.get("test.docker.compose.pullOnStartup", "true"));
        logger.info("{} = {}", (Object)"test.docker.compose.stream.apps.uri", (Object)DockerComposeFactoryProperties.get("test.docker.compose.stream.apps.uri", isDood ? KAFKA_DOCKER_STREAM_APPS_URI : "https://dataflow.spring.io/kafka-maven-latest&force=true"));
        logger.info("{} = {}", (Object)"test.docker.compose.task.apps.uri", (Object)DockerComposeFactoryProperties.get("test.docker.compose.task.apps.uri", isDood ? "https://dataflow.spring.io/task-docker-latest" : DEFAULT_TASK_APPS_URI));
        logger.info("{} = {}", (Object)"test.docker.compose.paths", (Object)DockerComposeFactoryProperties.getDockerComposePaths(DEFAULT_DOCKER_COMPOSE_PATHS));
        Object[] dockerComposePaths = new ResourceExtractor(tempFolder).extract(DockerComposeFactoryProperties.getDockerComposePaths(DEFAULT_DOCKER_COMPOSE_PATHS));
        if (isDood) {
            dockerComposePaths = DockerComposeFactory.addDockerComposeToPath((String[])dockerComposePaths, "../src/docker-compose/docker-compose-dood.yml");
            dockerComposePaths = DockerComposeFactory.addDockerComposeToPath((String[])dockerComposePaths, "./src/test/resources/docker-compose-docker-it-task-import.yml");
        } else {
            dockerComposePaths = DockerComposeFactory.addDockerComposeToPath((String[])dockerComposePaths, "./src/test/resources/docker-compose-maven-it-task-import.yml");
        }
        logger.info("Extracted docker compose files = {}", (Object)Arrays.toString(dockerComposePaths));
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            logger.warn("Failed to configure Skip SSL Verification!");
        }
        String waitingForServiceFormat = DockerComposeFactoryProperties.get("test.docker.compose.waiting.for.service.format", "http://$HOST:$EXTERNAL_PORT");
        return ((LegacyDockerComposeExtension.Builder)((LegacyDockerComposeExtension.Builder)((LegacyDockerComposeExtension.Builder)((LegacyDockerComposeExtension.Builder)((LegacyDockerComposeExtension.Builder)((LegacyDockerComposeExtension.Builder)((LegacyDockerComposeExtension.Builder)LegacyDockerComposeExtension.builder().projectName(ProjectName.fromString((String)"scdf"))).files(DockerComposeFiles.from((String[])dockerComposePaths))).machine(dockerMachine)).saveLogsTo("target/dockerLogs/DockerComposeIT")).waitingForService("dataflow-server", HealthChecks.toRespond2xxOverHttp((int)9393, port -> port.inFormat(waitingForServiceFormat)), (ReadableDuration)Duration.standardMinutes((long)10L))).waitingForService("skipper-server", HealthChecks.toRespond2xxOverHttp((int)7577, port -> port.inFormat(waitingForServiceFormat)), (ReadableDuration)Duration.standardMinutes((long)10L))).pullOnStartup(DockerComposeFactoryProperties.getBoolean("test.docker.compose.pullOnStartup", true))).build();
    }
}

