/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.integration.test.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DockerComposeFactoryProperties {
    private static final Logger logger = LoggerFactory.getLogger(DockerComposeFactoryProperties.class);
    private static final String PREFIX = "test.docker.compose.";
    public static final String TEST_DOCKER_COMPOSE_PATHS = "test.docker.compose.paths";
    public static final String TEST_DOCKER_COMPOSE_PULLONSTARTUP = "test.docker.compose.pullOnStartup";
    public static final String TEST_DOCKER_COMPOSE_DISABLE_EXTENSION = "test.docker.compose.disable.extension";
    public static final String TEST_DOCKER_COMPOSE_BP_JVM_VERSION = "test.docker.compose.bp.jvm.version.version";
    public static final String TEST_DOCKER_COMPOSE_DATAFLOW_VERSIONN = "test.docker.compose.dataflow.version";
    public static final String TEST_DOCKER_COMPOSE_SKIPPER_VERSIONN = "test.docker.compose.skipper.version";
    public static final String TEST_DOCKER_COMPOSE_DATAFLOW_URI = "test.docker.compose.dataflow.uri";
    public static final String TEST_DOCKER_COMPOSE_SKIPPER_URI = "test.docker.compose.skipper.uri";
    public static final String TEST_DOCKER_COMPOSE_TASK_APPS_URI = "test.docker.compose.task.apps.uri";
    public static final String TEST_DOCKER_COMPOSE_STREAM_APPS_URI = "test.docker.compose.stream.apps.uri";
    public static final String TEST_DOCKER_COMPOSE_APPS_PORT_RANGE = "test.docker.compose.apps.port.range";
    public static final String TEST_DOCKER_COMPOSE_DOOD = "test.docker.compose.dood";
    public static final String TEST_DOCKER_COMPOSE_DOCKER_DELETE_CONTAINER_ON_EXIT = "test.docker.compose.docker.delete.container.on.exit";
    public static final String TEST_DOCKER_COMPOSE_WAITING_FOR_SERVICE_FORMAT = "test.docker.compose.waiting.for.service.format";

    public static boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = DockerComposeFactoryProperties.get(propertyName, "" + defaultValue);
        return Boolean.valueOf(value);
    }

    public static String get(String propertyName, String defaultValue) {
        return StringUtils.hasText((String)DockerComposeFactoryProperties.getPropertyOrVariableValue(propertyName)) ? DockerComposeFactoryProperties.getPropertyOrVariableValue(propertyName) : defaultValue;
    }

    public static boolean isDockerComposeDisabled() {
        return DockerComposeFactoryProperties.getBoolean(TEST_DOCKER_COMPOSE_DISABLE_EXTENSION, false);
    }

    public static String[] getDockerComposePaths(String[] defaultPaths) {
        return StringUtils.hasText((String)DockerComposeFactoryProperties.getPropertyOrVariableValue(TEST_DOCKER_COMPOSE_PATHS)) ? DockerComposeFactoryProperties.toCSV(DockerComposeFactoryProperties.getPropertyOrVariableValue(TEST_DOCKER_COMPOSE_PATHS)) : defaultPaths;
    }

    private static String[] toCSV(String txt) {
        return Arrays.stream(txt.split(",")).filter(p -> StringUtils.hasText((String)p)).map(p -> p.trim()).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static String toEnv(String property) {
        return property.trim().toUpperCase().replace(".", "_");
    }

    private static String getPropertyOrVariableValue(String propertyName) {
        if (StringUtils.hasText((String)System.getProperty(propertyName))) {
            return System.getProperty(propertyName);
        }
        if (StringUtils.hasText((String)System.getenv(DockerComposeFactoryProperties.toEnv(propertyName)))) {
            return System.getenv(DockerComposeFactoryProperties.toEnv(propertyName));
        }
        return null;
    }
}

