/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.util.Arrays;
import org.springframework.util.Assert;

public class Assertions {
    private Assertions() {
    }

    public static int exactlyOneOf(Object ... namesAndValues) {
        int index = Assertions.atMostOneOf(namesAndValues);
        Assert.state((index >= 0 ? 1 : 0) != 0, (String)("You must specify exactly one of " + Assertions.collectNames(namesAndValues)));
        return index;
    }

    public static int atMostOneOf(Object ... namesAndValues) {
        int index = -1;
        Assert.isTrue((namesAndValues.length % 2 == 0 ? 1 : 0) != 0, (String)("Expected even number of arguments: " + Arrays.asList(namesAndValues)));
        for (int i = 0; i < namesAndValues.length / 2; ++i) {
            Assert.isTrue((boolean)(namesAndValues[i * 2] instanceof String), (String)("Argument at position " + i + " should be argument name"));
            if (namesAndValues[i * 2 + 1] == null || namesAndValues[i * 2 + 1] == Boolean.FALSE) continue;
            if (index != -1) {
                throw new IllegalStateException(String.format("You cannot specify both '%s' and '%s'", namesAndValues[index * 2], namesAndValues[i * 2]));
            }
            index = i;
        }
        return index;
    }

    private static String collectNames(Object[] namesAndValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < namesAndValues.length; i += 2) {
            sb.append('\'').append(namesAndValues[i]).append("', ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

