/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.shell.config.DataFlowShell;
import org.springframework.shell.CommandLine;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class ConfigCommands
implements CommandMarker,
InitializingBean {
    @Autowired
    private CommandLine commandLine;
    @Autowired
    private DataFlowShell shell;
    public static final String DEFAULT_SCHEME = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9393;
    public static final String DEFAULT_TARGET = "http://localhost:9393/";

    @CliCommand(value={"admin config server"}, help="Configure the Spring Cloud Data Flow REST server to use")
    public String target(@CliOption(mandatory=false, key={"", "uri"}, help="the location of the Spring Cloud Data Flow REST endpoint", unspecifiedDefaultValue="http://localhost:9393/") String targetUriString) {
        try {
            URI baseURI = URI.create(targetUriString);
            this.shell.setDataFlowOperations((DataFlowOperations)new DataFlowTemplate(baseURI));
            return String.format("Successfully targeted %s", targetUriString);
        }
        catch (Exception e) {
            this.shell.setDataFlowOperations(null);
            return String.format("Unable to contact Data Flow Admin at '%s'.", targetUriString);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.target(this.getDefaultUri().toString());
    }

    private URI getDefaultUri() throws URISyntaxException {
        int port = 9393;
        String host = DEFAULT_HOST;
        if (this.commandLine.getArgs() != null) {
            String[] args = this.commandLine.getArgs();
            int i = 0;
            while (i < args.length) {
                String arg;
                if ((arg = args[i++]).equals("--host")) {
                    host = args[i++];
                    continue;
                }
                if (arg.equals("--port")) {
                    port = Integer.valueOf(args[i++]);
                    continue;
                }
                --i;
                break;
            }
        }
        return new URI(DEFAULT_SCHEME, null, host, port, null, null, null);
    }
}

