/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.dataflow.shell.command.UserInput;
import org.springframework.stereotype.Component;

@Component
public class ConsoleUserInput
implements UserInput {
    @Override
    public String promptWithOptions(String prompt, String defaultValue, String ... options) {
        String answer;
        List<String> optionsAsList = Arrays.asList(options);
        InputStreamReader console = new InputStreamReader(System.in);
        do {
            System.out.format("%s %s: ", prompt, optionsAsList);
        } while (!optionsAsList.contains(answer = this.read(console, true)) && !"".equals(answer));
        return "".equals(answer) && !optionsAsList.contains("") ? defaultValue : answer;
    }

    @Override
    public String prompt(String prompt, String defaultValue, boolean echo) {
        InputStreamReader console = new InputStreamReader(System.in);
        System.out.format("%s: ", prompt);
        String answer = this.read(console, echo);
        return "".equals(answer) ? defaultValue : answer;
    }

    private String read(InputStreamReader console, boolean echo) {
        StringBuilder builder = new StringBuilder();
        try {
            char c = (char)console.read();
            while (c != '\n' && c != '\r') {
                if (echo) {
                    System.out.print(c);
                }
                builder.append(c);
                c = (char)console.read();
            }
            System.out.println();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return builder.toString();
    }
}

