/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.text.NumberFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.rest.client.CounterOperations;
import org.springframework.cloud.dataflow.rest.resource.CounterResource;
import org.springframework.cloud.dataflow.rest.resource.MetricResource;
import org.springframework.cloud.dataflow.shell.command.AbstractMetricsCommands;
import org.springframework.cloud.dataflow.shell.config.DataFlowShell;
import org.springframework.hateoas.PagedResources;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.table.Table;
import org.springframework.stereotype.Component;

@Component
public class CounterCommands
extends AbstractMetricsCommands
implements CommandMarker {
    private static final String DISPLAY_COUNTER = "counter display";
    private static final String LIST_COUNTERS = "counter list";
    private static final String DELETE_COUNTER = "counter reset";
    @Autowired
    private DataFlowShell dataFlowShell;

    protected CounterCommands() {
        super("Counter");
    }

    @CliAvailabilityIndicator(value={"counter list", "counter display", "counter reset"})
    public boolean available() {
        return this.dataFlowShell.getDataFlowOperations() != null;
    }

    @CliCommand(value={"counter display"}, help="Display the value of a counter")
    public String display(@CliOption(key={"", "name"}, help="the name of the counter to display", mandatory=true) String name, @CliOption(key={"pattern"}, help="the pattern used to format the value (see DecimalFormat)", mandatory=false, unspecifiedDefaultValue="<use platform locale>") NumberFormat pattern) {
        CounterResource counter = this.counterOperations().retrieve(name);
        return pattern.format(counter.getValue());
    }

    @CliCommand(value={"counter list"}, help="List all available counter names")
    public Table list() {
        PagedResources list = this.counterOperations().list();
        return this.displayMetrics((PagedResources<MetricResource>)list);
    }

    @CliCommand(value={"counter reset"}, help="Reset the counter with the given name")
    public String reset(@CliOption(mandatory=true, key={"", "name"}, help="the name of the counter to reset") String name) {
        this.counterOperations().reset(name);
        return String.format("Deleted counter '%s'", name);
    }

    private CounterOperations counterOperations() {
        return this.dataFlowShell.getDataFlowOperations().counterOperations();
    }
}

