/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.core.ModuleType;
import org.springframework.cloud.dataflow.rest.client.ModuleOperations;
import org.springframework.cloud.dataflow.rest.resource.DetailedModuleRegistrationResource;
import org.springframework.cloud.dataflow.rest.resource.ModuleRegistrationResource;
import org.springframework.cloud.dataflow.shell.command.ModuleList;
import org.springframework.cloud.dataflow.shell.config.DataFlowShell;
import org.springframework.hateoas.PagedResources;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.table.Table;
import org.springframework.shell.support.table.TableHeader;
import org.springframework.shell.support.table.TableRow;
import org.springframework.stereotype.Component;

@Component
public class ModuleCommands
implements CommandMarker {
    private static final String LIST_MODULES = "module list";
    private static final String MODULE_INFO = "module info";
    private static final String UNREGISTER_MODULE = "module unregister";
    private static final String REGISTER_MODULE = "module register";
    @Autowired
    private DataFlowShell dataFlowShell;

    @CliAvailabilityIndicator(value={"module list", "module info", "module unregister", "module register"})
    public boolean available() {
        return this.dataFlowShell.getDataFlowOperations() != null;
    }

    @CliCommand(value={"module info"}, help="Get information about a module")
    public String info(@CliOption(mandatory=true, key={"", "name"}, help="name of the module to query") String name, @CliOption(mandatory=false, key={"type"}, help="type of the module to query") ModuleType type, @CliOption(key={"hidden"}, help="whether to show 'hidden' options", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean showHidden) {
        QualifiedModuleName module = this.processArgs(name, type);
        DetailedModuleRegistrationResource info = this.moduleOperations().info(module.name, module.type);
        List options = info.getOptions();
        StringBuilder result = new StringBuilder();
        result.append("Information about ").append(module.type.name()).append(" module '").append(module.name).append("':\n\n");
        result.append("Maven coordinates: ").append(info.getCoordinates()).append("\n\n");
        if (info.getShortDescription() != null) {
            result.append(info.getShortDescription()).append("\n\n");
        }
        if (options == null) {
            result.append("Module options metadata is not available");
        } else {
            Table table = new Table().addHeader(Integer.valueOf(1), new TableHeader("Option Name")).addHeader(Integer.valueOf(2), new TableHeader("Description")).addHeader(Integer.valueOf(3), new TableHeader("Default")).addHeader(Integer.valueOf(4), new TableHeader("Type"));
            for (DetailedModuleRegistrationResource.Option o : options) {
                if (!showHidden && o.isHidden()) continue;
                TableRow row = new TableRow();
                row.addValue(Integer.valueOf(1), o.getName()).addValue(Integer.valueOf(2), o.getDescription()).addValue(Integer.valueOf(3), this.prettyPrintDefaultValue(o)).addValue(Integer.valueOf(4), o.getType() == null ? "<unknown>" : o.getType());
                table.getRows().add(row);
            }
            result.append(table.toString());
        }
        return result.toString();
    }

    @CliCommand(value={"module register"}, help="Register a new module")
    public String register(@CliOption(mandatory=true, key={"", "name"}, help="the name for the registered module") String name, @CliOption(mandatory=true, key={"type"}, help="the type for the registered module") ModuleType type, @CliOption(mandatory=true, key={"coordinates"}, help="coordinates to the module archive") String coordinates, @CliOption(key={"force"}, help="force update if module already exists (only if not in use)", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean force) {
        this.moduleOperations().register(name, type, coordinates, force);
        return String.format("Successfully registered module '%s:%s'", type, name);
    }

    @CliCommand(value={"module unregister"}, help="Unregister a module")
    public String unregister(@CliOption(mandatory=true, key={"", "name"}, help="name of the module to unregister") String name, @CliOption(mandatory=false, key={"type"}, help="type of the module to unregister") ModuleType type) {
        QualifiedModuleName module = this.processArgs(name, type);
        this.moduleOperations().unregister(module.name, module.type);
        return String.format("Successfully unregistered module '%s' with type %s", module.name, module.type);
    }

    @CliCommand(value={"module list"}, help="List all modules")
    public Table list() {
        PagedResources modules = this.moduleOperations().list();
        return new ModuleList((Iterable<ModuleRegistrationResource>)modules).renderByType();
    }

    private String prettyPrintDefaultValue(DetailedModuleRegistrationResource.Option o) {
        if (o.getDefaultValue() == null) {
            return "<none>";
        }
        return o.getDefaultValue().replace("\n", "\\n").replace("\t", "\\t").replace("\f", "\\f");
    }

    private ModuleOperations moduleOperations() {
        return this.dataFlowShell.getDataFlowOperations().moduleOperations();
    }

    private QualifiedModuleName processArgs(String name, ModuleType type) {
        if (type == null) {
            String[] split = name.split("\\:");
            if (split.length != 2) {
                throw new IllegalArgumentException(String.format("Expected format of 'name:type' for module name %s", name));
            }
            return new QualifiedModuleName(split[0], ModuleType.valueOf((String)split[1]));
        }
        return new QualifiedModuleName(name, type);
    }

    private static class QualifiedModuleName {
        public ModuleType type;
        public String name;

        public QualifiedModuleName(String name, ModuleType type) {
            this.name = name;
            this.type = type;
        }
    }
}

