/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.dataflow.core.ModuleType;
import org.springframework.cloud.dataflow.rest.resource.ModuleRegistrationResource;
import org.springframework.shell.support.table.Table;
import org.springframework.shell.support.table.TableHeader;
import org.springframework.shell.support.table.TableRow;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ModuleList {
    private Iterable<ModuleRegistrationResource> modules;
    private static final Map<String, Integer> typeToColumn = new LinkedHashMap<String, Integer>();

    public ModuleList(Iterable<ModuleRegistrationResource> modules) {
        Assert.notNull(modules);
        this.modules = modules;
    }

    public Table renderByType() {
        Table table = new Table();
        int i = 1;
        HashMap<String, Integer> currentRowByType = new HashMap<String, Integer>();
        for (String type : typeToColumn.keySet()) {
            table.addHeader(Integer.valueOf(i++), new TableHeader("    " + StringUtils.capitalize((String)type)));
        }
        for (ModuleRegistrationResource module : this.modules) {
            TableRow row = this.rowForType(module.getType(), table, currentRowByType);
            row.addValue(typeToColumn.get(module.getType()), module.getName());
        }
        return table;
    }

    private TableRow rowForType(String type, Table table, Map<String, Integer> currentRowByType) {
        TableRow result;
        Integer value = currentRowByType.get(type);
        if (value == null) {
            value = 0;
        }
        currentRowByType.put(type, value + 1);
        if (value >= table.getRows().size()) {
            result = new TableRow();
            for (int i = 1; i <= typeToColumn.size(); ++i) {
                result.addValue(Integer.valueOf(i), "");
            }
            table.getRows().add(result);
        } else {
            result = (TableRow)table.getRows().get(value);
        }
        return result;
    }

    static {
        int i = 0;
        while (i < ModuleType.values().length) {
            typeToColumn.put(ModuleType.values()[i].name(), ++i);
        }
    }
}

