/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.rest.client.StreamOperations;
import org.springframework.cloud.dataflow.rest.resource.StreamDefinitionResource;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.cloud.dataflow.shell.command.Assertions;
import org.springframework.cloud.dataflow.shell.command.UserInput;
import org.springframework.cloud.dataflow.shell.config.DataFlowShell;
import org.springframework.hateoas.PagedResources;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.table.Table;
import org.springframework.shell.support.table.TableHeader;
import org.springframework.stereotype.Component;

@Component
public class StreamCommands
implements CommandMarker {
    private static final String LIST_STREAM = "stream list";
    private static final String CREATE_STREAM = "stream create";
    private static final String DEPLOY_STREAM = "stream deploy";
    private static final String UNDEPLOY_STREAM = "stream undeploy";
    private static final String UNDEPLOY_STREAM_ALL = "stream all undeploy";
    private static final String DESTROY_STREAM = "stream destroy";
    private static final String DESTROY_STREAM_ALL = "stream all destroy";
    private static final String PROPERTIES_OPTION = "properties";
    private static final String PROPERTIES_FILE_OPTION = "propertiesFile";
    @Autowired
    private DataFlowShell dataFlowShell;
    @Autowired
    private UserInput userInput;

    @CliAvailabilityIndicator(value={"stream list", "stream create", "stream deploy", "stream undeploy", "stream all undeploy", "stream destroy", "stream all destroy"})
    public boolean available() {
        return this.dataFlowShell.getDataFlowOperations() != null;
    }

    @CliCommand(value={"stream list"}, help="List created streams")
    public Table listStreams() {
        PagedResources streams = this.streamOperations().list();
        Table table = new Table().addHeader(Integer.valueOf(1), new TableHeader("Stream Name")).addHeader(Integer.valueOf(2), new TableHeader("Stream Definition")).addHeader(Integer.valueOf(3), new TableHeader("Status"));
        for (StreamDefinitionResource stream : streams) {
            table.newRow().addValue(Integer.valueOf(1), stream.getName()).addValue(Integer.valueOf(2), stream.getDslText()).addValue(Integer.valueOf(3), stream.getStatus());
        }
        return table;
    }

    @CliCommand(value={"stream create"}, help="Create a new stream definition")
    public String createStream(@CliOption(mandatory=true, key={"", "name"}, help="the name to give to the stream") String name, @CliOption(mandatory=true, key={"definition"}, help="a stream definition, using the DSL (e.g. \"http --port=9000 | hdfs\")") String dsl, @CliOption(key={"deploy"}, help="whether to deploy the stream immediately", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean deploy) {
        this.streamOperations().createStream(name, dsl, deploy);
        return deploy ? String.format("Created and deployed new stream '%s'", name) : String.format("Created new stream '%s'", name);
    }

    @CliCommand(value={"stream deploy"}, help="Deploy a previously created stream")
    public String deployStream(@CliOption(key={"", "name"}, help="the name of the stream to deploy", mandatory=true) String name, @CliOption(key={"properties"}, help="the properties for this deployment", mandatory=false) String properties, @CliOption(key={"propertiesFile"}, help="the properties for this deployment (as a File)", mandatory=false) File propertiesFile) throws IOException {
        Map propertiesToUse;
        int which = Assertions.atMostOneOf(PROPERTIES_OPTION, properties, PROPERTIES_FILE_OPTION, propertiesFile);
        switch (which) {
            case 0: {
                propertiesToUse = DeploymentPropertiesUtils.parse((String)properties);
                break;
            }
            case 1: {
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(propertiesFile);){
                    props.load(fis);
                }
                propertiesToUse = DeploymentPropertiesUtils.convert((Properties)props);
                break;
            }
            case -1: {
                propertiesToUse = Collections.emptyMap();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.streamOperations().deploy(name, propertiesToUse);
        return String.format("Deployed stream '%s'", name);
    }

    @CliCommand(value={"stream undeploy"}, help="Un-deploy a previously deployed stream")
    public String undeployStream(@CliOption(key={"", "name"}, help="the name of the stream to un-deploy", mandatory=true) String name) {
        this.streamOperations().undeploy(name);
        return String.format("Un-deployed stream '%s'", name);
    }

    @CliCommand(value={"stream all undeploy"}, help="Un-deploy all previously deployed stream")
    public String undeployAllStreams(@CliOption(key={"force"}, help="bypass confirmation prompt", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean force) {
        if (force || "y".equalsIgnoreCase(this.userInput.promptWithOptions("Really undeploy all streams?", "n", "y", "n"))) {
            this.streamOperations().undeployAll();
            return String.format("Un-deployed all the streams", new Object[0]);
        }
        return "";
    }

    @CliCommand(value={"stream destroy"}, help="Destroy an existing stream")
    public String destroyStream(@CliOption(key={"", "name"}, help="the name of the stream to destroy", mandatory=true) String name) {
        this.streamOperations().destroy(name);
        return String.format("Destroyed stream '%s'", name);
    }

    @CliCommand(value={"stream all destroy"}, help="Destroy all existing streams")
    public String destroyAllStreams(@CliOption(key={"force"}, help="bypass confirmation prompt", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean force) {
        if (force || "y".equalsIgnoreCase(this.userInput.promptWithOptions("Really destroy all streams?", "n", "y", "n"))) {
            this.streamOperations().destroyAll();
            return "Destroyed all streams";
        }
        return "";
    }

    StreamOperations streamOperations() {
        return this.dataFlowShell.getDataFlowOperations().streamOperations();
    }
}

