/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.resource.TaskDefinitionResource;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.cloud.dataflow.shell.command.Assertions;
import org.springframework.cloud.dataflow.shell.config.DataFlowShell;
import org.springframework.hateoas.PagedResources;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.table.Table;
import org.springframework.shell.support.table.TableHeader;
import org.springframework.stereotype.Component;

@Component
public class TaskCommands
implements CommandMarker {
    private static final String LIST = "task list";
    private static final String CREATE = "task create";
    private static final String LAUNCH = "task launch";
    private static final String STATUS = "task status";
    private static final String DESTROY = "task destroy";
    private static final String PROPERTIES_OPTION = "properties";
    private static final String PROPERTIES_FILE_OPTION = "propertiesFile";
    @Autowired
    private DataFlowShell dataFlowShell;

    @CliAvailabilityIndicator(value={"task list", "task create", "task launch", "task status", "task destroy"})
    public boolean available() {
        return this.dataFlowShell.getDataFlowOperations() != null;
    }

    @CliCommand(value={"task list"}, help="List created tasks")
    public Table list() {
        PagedResources tasks = this.taskOperations().list();
        Table table = new Table().addHeader(Integer.valueOf(1), new TableHeader("Task Name")).addHeader(Integer.valueOf(2), new TableHeader("Task Definition")).addHeader(Integer.valueOf(3), new TableHeader("Task Status"));
        for (TaskDefinitionResource task : tasks) {
            table.newRow().addValue(Integer.valueOf(1), task.getName()).addValue(Integer.valueOf(2), task.getDslText()).addValue(Integer.valueOf(3), task.getStatus() == null ? "" : task.getStatus());
        }
        return table;
    }

    @CliCommand(value={"task create"}, help="Create a new task definition")
    public String create(@CliOption(mandatory=true, key={"", "name"}, help="the name to give to the task") String name, @CliOption(mandatory=true, key={"definition"}, help="a task definition, using the DSL (e.g. \"taskName\")") String dsl) {
        this.taskOperations().create(name, dsl);
        return String.format("Created new task '%s'", name);
    }

    @CliCommand(value={"task launch"}, help="Launch a previously created task")
    public String launch(@CliOption(key={"", "name"}, help="the name of the task to launch", mandatory=true) String name, @CliOption(key={"properties"}, help="the properties for this launch", mandatory=false) String properties, @CliOption(key={"propertiesFile"}, help="the properties for this launch (as a File)", mandatory=false) File propertiesFile) throws IOException {
        Map propertiesToUse;
        int which = Assertions.atMostOneOf(PROPERTIES_OPTION, properties, PROPERTIES_FILE_OPTION, propertiesFile);
        switch (which) {
            case 0: {
                propertiesToUse = DeploymentPropertiesUtils.parse((String)properties);
                break;
            }
            case 1: {
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(propertiesFile);){
                    props.load(fis);
                }
                propertiesToUse = DeploymentPropertiesUtils.convert((Properties)props);
                break;
            }
            case -1: {
                propertiesToUse = Collections.emptyMap();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.taskOperations().launch(name, propertiesToUse);
        return String.format("Launched task '%s'", name);
    }

    @CliCommand(value={"task destroy"}, help="Destroy an existing task")
    public String destroy(@CliOption(key={"", "name"}, help="the name of the task to destroy", mandatory=true) String name) {
        this.taskOperations().destroy(name);
        return String.format("Destroyed task '%s'", name);
    }

    @CliCommand(value={"task status"}, help="Retrieve status info on an existing task")
    public String status(@CliOption(key={"", "name"}, help="the name of the task ", mandatory=true) String name) {
        return String.format("Feature Not Available", new Object[0]);
    }

    private TaskOperations taskOperations() {
        return this.dataFlowShell.getDataFlowOperations().taskOperations();
    }
}

