/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.config;

import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.BannerProvider;
import org.springframework.shell.support.util.FileUtils;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class DataFlowBannerProvider
implements BannerProvider {
    private static final String WELCOME = "Welcome to the Spring Cloud Data Flow shell. For assistance hit TAB or type \"help\".";

    public String getProviderName() {
        return "dataflow";
    }

    public String getBanner() {
        StringBuilder banner = new StringBuilder();
        banner.append(FileUtils.readBanner(DataFlowBannerProvider.class, (String)"/banner.txt"));
        banner.append("\n" + this.getVersion() + "\n");
        return banner.toString();
    }

    public String getVersion() {
        Package pkg = DataFlowBannerProvider.class.getPackage();
        String version = null;
        if (pkg != null) {
            version = pkg.getImplementationVersion();
        }
        return version != null ? version : "Unknown Version";
    }

    public String getWelcomeMessage() {
        return WELCOME;
    }
}

