/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.shell.converter;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.stereotype.Component;

@Component
public class NumberFormatConverter
implements Converter<NumberFormat> {
    public static final String DEFAULT = "<use platform locale>";

    public boolean supports(Class<?> type, String optionContext) {
        return NumberFormat.class.isAssignableFrom(type);
    }

    public NumberFormat convertFromText(String value, Class<?> targetType, String optionContext) {
        if (DEFAULT.equals(value)) {
            return NumberFormat.getInstance();
        }
        return new DecimalFormat(value);
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        return false;
    }
}

