/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.deployer.spi.cloudfoundry;

/**
 * Strategy interface for generating the names of deployed applications. *
 *
 * @author Soby Chacko
 */
public interface AppNameGenerator {

	/**
	 * Generate an application name given a base name as the starting point.
	 *
	 * @param appName base application name
	 * @return the generated app name
	 */
	String generateAppName(String appName);

}
