/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScallableResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;

public class KubernetesAppDeployer
extends AbstractKubernetesDeployer
implements AppDeployer {
    private static final String SERVER_PORT_KEY = "server.port";
    private final KubernetesClient client;

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        this.containerFactory = containerFactory;
    }

    public String deploy(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        logger.debug((Object)String.format("Deploying app: %s", appId));
        try {
            boolean indexed;
            AppStatus status = this.status(appId);
            if (!status.getState().equals((Object)DeploymentState.unknown)) {
                throw new IllegalStateException(String.format("App '%s' is already deployed", appId));
            }
            int externalPort = this.configureExternalPort(request);
            String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
            int count = countProperty != null ? Integer.parseInt(countProperty) : 1;
            String indexedProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.indexed");
            boolean bl = indexed = indexedProperty != null ? Boolean.valueOf(indexedProperty) : false;
            if (indexed) {
                for (int index = 0; index < count; ++index) {
                    String indexedId = appId + "-" + index;
                    Map<String, String> idMap = this.createIdMap(appId, request, index);
                    logger.debug((Object)String.format("Creating service: %s on %d with index %d", appId, externalPort, index));
                    this.createService(indexedId, request, idMap, externalPort);
                    logger.debug((Object)String.format("Creating repl controller: %s with index %d", appId, index));
                    this.createReplicationController(indexedId, request, idMap, externalPort, 1, index);
                }
            } else {
                Map<String, String> idMap = this.createIdMap(appId, request, null);
                logger.debug((Object)String.format("Creating service: %s on {}", appId, externalPort));
                this.createService(appId, request, idMap, externalPort);
                logger.debug((Object)String.format("Creating repl controller: %s", appId));
                this.createReplicationController(appId, request, idMap, externalPort, count, null);
            }
            return appId;
        }
        catch (RuntimeException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void undeploy(String appId) {
        logger.debug((Object)String.format("Undeploying app: %s", appId));
        AppStatus status = this.status(appId);
        if (status.getState().equals((Object)DeploymentState.unknown)) {
            throw new IllegalStateException(String.format("App '%s' is not deployed", appId));
        }
        List apps = ((ReplicationControllerList)((FilterWatchListDeletable)this.client.replicationControllers().withLabel("spring-app-id", appId)).list()).getItems();
        if (apps != null) {
            for (ReplicationController rc : apps) {
                String appIdToDelete = rc.getMetadata().getName();
                logger.debug((Object)String.format("Deleting svc, rc and pods for: %s", appIdToDelete));
                Service svc = (Service)((Resource)this.client.services().withName(appIdToDelete)).get();
                try {
                    if (svc != null && "LoadBalancer".equals(svc.getSpec().getType())) {
                        int tries = 0;
                        int maxWait = this.properties.getMinutesToWaitForLoadBalancer() * 6;
                        while (tries++ < maxWait && svc.getStatus() != null && svc.getStatus().getLoadBalancer() != null && svc.getStatus().getLoadBalancer().getIngress() != null && svc.getStatus().getLoadBalancer().getIngress().isEmpty()) {
                            if (tries % 6 == 0) {
                                logger.warn((Object)"Waiting for LoadBalancer to complete before deleting it ...");
                            }
                            logger.debug((Object)String.format("Waiting for LoadBalancer, try %d", tries));
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            svc = (Service)((Resource)this.client.services().withName(appIdToDelete)).get();
                        }
                        logger.debug((Object)String.format("LoadBalancer Ingress: %s", svc.getStatus().getLoadBalancer().getIngress().toString()));
                    }
                    Boolean svcDeleted = (Boolean)((Resource)this.client.services().withName(appIdToDelete)).delete();
                    logger.debug((Object)String.format("Deleted service for: %s %b", appIdToDelete, svcDeleted));
                    Boolean rcDeleted = (Boolean)((RollableScallableResource)this.client.replicationControllers().withName(appIdToDelete)).delete();
                    logger.debug((Object)String.format("Deleted replication controller for: %s %b", appIdToDelete, rcDeleted));
                    HashMap<String, String> selector = new HashMap<String, String>();
                    selector.put("spring-app-id", appIdToDelete);
                    FilterWatchListDeletable podsToDelete = (FilterWatchListDeletable)this.client.pods().withLabels(selector);
                    if (podsToDelete != null && ((PodList)podsToDelete.list()).getItems() != null) {
                        Boolean podDeleted = (Boolean)podsToDelete.delete();
                        logger.debug((Object)String.format("Deleted pods for: %s %b", appIdToDelete, podDeleted));
                        continue;
                    }
                    logger.debug((Object)String.format("No pods to delete for: %s", appIdToDelete));
                }
                catch (RuntimeException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public AppStatus status(String appId) {
        HashMap<String, String> selector = new HashMap<String, String>();
        selector.put("spring-app-id", appId);
        PodList list = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Building AppStatus for app: %s", appId));
            if (list != null && list.getItems() != null) {
                logger.debug((Object)String.format("Pods for appId %s: %d", appId, list.getItems().size()));
                for (Pod pod : list.getItems()) {
                    logger.debug((Object)String.format("Pod: %s", pod.getMetadata().getName()));
                }
            }
        }
        AppStatus status = this.buildAppStatus(appId, list);
        logger.debug((Object)String.format("Status for app: %s is %s", appId, status));
        return status;
    }

    protected int configureExternalPort(AppDeploymentRequest request) {
        int externalPort = 8080;
        Map parameters = request.getDefinition().getProperties();
        if (parameters.containsKey(SERVER_PORT_KEY)) {
            externalPort = Integer.valueOf((String)parameters.get(SERVER_PORT_KEY));
        }
        return externalPort;
    }

    protected String createDeploymentId(AppDeploymentRequest request) {
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = groupId == null ? String.format("%s", request.getDefinition().getName()) : String.format("%s-%s", groupId, request.getDefinition().getName());
        return deploymentId.replace('.', '-').toLowerCase();
    }

    private ReplicationController createReplicationController(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort, int replicas, Integer instanceIndex) {
        ReplicationController rc = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(replicas))).withSelector(idMap)).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(this.createPodSpec(appId, request, externalPort, instanceIndex, false))).endTemplate()).endSpec()).build();
        return (ReplicationController)this.client.replicationControllers().create((Object[])new ReplicationController[]{rc});
    }

    private void createService(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        ServiceSpecBuilder spec = new ServiceSpecBuilder();
        boolean isCreateLoadBalancer = false;
        String createLoadBalancer = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createLoadBalancer");
        String createNodePort = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createNodePort");
        if (createLoadBalancer != null && createNodePort != null) {
            throw new IllegalArgumentException("Cannot create NodePort and LoadBalancer at the same time.");
        }
        if (createLoadBalancer == null) {
            isCreateLoadBalancer = this.properties.isCreateLoadBalancer();
        } else if ("true".equals(createLoadBalancer.toLowerCase())) {
            isCreateLoadBalancer = true;
        }
        if (isCreateLoadBalancer) {
            spec.withType("LoadBalancer");
        }
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(externalPort));
        if (createNodePort != null) {
            spec.withType("NodePort");
            if (!"true".equals(createNodePort.toLowerCase())) {
                try {
                    Integer nodePort = Integer.valueOf(createNodePort);
                    servicePort.setNodePort(nodePort);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid value: %s: provided port is not valid.", createNodePort));
                }
            }
        }
        ((ServiceSpecBuilder)spec.withSelector(idMap)).addNewPortLike(servicePort).endPort();
        ((DoneableService)((DoneableService)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((DoneableService)((NonNamespaceOperation)this.client.services().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(spec.build())).done();
    }
}

