/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.HashMap;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.LocalAppDeployer;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.core.io.Resource;

public class TickTock {
    public static void main(String[] args) throws InterruptedException {
        LocalAppDeployer deployer = new LocalAppDeployer(new LocalDeployerProperties());
        String logId = deployer.deploy(TickTock.createAppDeploymentRequest("log-sink-kafka", "ticktock"));
        String timeId = deployer.deploy(TickTock.createAppDeploymentRequest("time-source-kafka", "ticktock"));
        for (int i = 0; i < 12; ++i) {
            Thread.sleep(5000L);
            System.out.println("time: " + deployer.status(timeId));
            System.out.println("log:  " + deployer.status(logId));
        }
        deployer.undeploy(timeId);
        deployer.undeploy(logId);
        System.out.println("time after undeploy: " + deployer.status(timeId));
        System.out.println("log after undeploy:  " + deployer.status(logId));
    }

    private static AppDeploymentRequest createAppDeploymentRequest(String app, String stream) {
        MavenResource resource = new MavenResource.Builder().artifactId(app).groupId("org.springframework.cloud.stream.app").version("1.0.0.BUILD-SNAPSHOT").build();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("server.port", "0");
        if (app.contains("-source-")) {
            properties.put("spring.cloud.stream.bindings.output.destination", stream);
        } else {
            properties.put("spring.cloud.stream.bindings.input.destination", stream);
            properties.put("spring.cloud.stream.bindings.input.group", "default");
        }
        AppDefinition definition = new AppDefinition(app, properties);
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        deploymentProperties.put("spring.cloud.deployer.group", stream);
        deploymentProperties.put("spring.cloud.deployer.local.inheritLogging", "true");
        AppDeploymentRequest request = new AppDeploymentRequest(definition, (Resource)resource, deploymentProperties);
        return request;
    }
}

