/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.adapter.aws.SpringBootRequestHandler;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.GenericMessage;

public class SpringBootApiGatewayRequestHandler
extends SpringBootRequestHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private FunctionInspector inspector;

    public SpringBootApiGatewayRequestHandler(Class<?> configurationClass) {
        super(configurationClass);
    }

    public SpringBootApiGatewayRequestHandler() {
    }

    @Override
    protected Object convertEvent(APIGatewayProxyRequestEvent event) {
        Object body = this.deserializeBody(event.getBody());
        if (this.functionAcceptsMessage()) {
            return new GenericMessage(body, this.getHeaders(event));
        }
        return body;
    }

    private boolean functionAcceptsMessage() {
        return this.inspector.isMessage(this.function());
    }

    private Object deserializeBody(String json) {
        try {
            return this.mapper.readValue(json, this.getInputType());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert event", e);
        }
    }

    private MessageHeaders getHeaders(APIGatewayProxyRequestEvent event) {
        HashMap<String, APIGatewayProxyRequestEvent> headers = new HashMap<String, APIGatewayProxyRequestEvent>();
        if (event.getHeaders() != null) {
            headers.putAll(event.getHeaders());
        }
        headers.put("request", event);
        return new MessageHeaders(headers);
    }

    @Override
    protected APIGatewayProxyResponseEvent convertOutput(Object output) {
        if (this.functionReturnsMessage(output)) {
            Message message = (Message)output;
            return new APIGatewayProxyResponseEvent().withStatusCode((Integer)message.getHeaders().getOrDefault((Object)"statusCode", (Object)200)).withHeaders(this.toResponseHeaders(message.getHeaders())).withBody(this.serializeBody(message.getPayload()));
        }
        return new APIGatewayProxyResponseEvent().withStatusCode(Integer.valueOf(200)).withBody(this.serializeBody(output));
    }

    private boolean functionReturnsMessage(Object output) {
        return output instanceof Message;
    }

    private Map<String, String> toResponseHeaders(MessageHeaders messageHeaders) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        messageHeaders.forEach((key, value) -> responseHeaders.put((String)key, value.toString()));
        return responseHeaders;
    }

    private String serializeBody(Object body) {
        try {
            return this.mapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot convert output", e);
        }
    }
}

