/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;

public class SpringFunctionInitializer
implements Closeable {
    private static Log logger = LogFactory.getLog(SpringFunctionInitializer.class);
    private final Class<?> configurationClass;
    private Function<Flux<?>, Publisher<?>> function;
    private Consumer<Flux<?>> consumer;
    private Supplier<Flux<?>> supplier;
    private AtomicBoolean initialized = new AtomicBoolean();
    @Autowired(required=false)
    private FunctionInspector inspector;
    @Autowired(required=false)
    private FunctionCatalog catalog;
    private ConfigurableApplicationContext context;

    public SpringFunctionInitializer(Class<?> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public SpringFunctionInitializer() {
        this(SpringFunctionInitializer.getStartClass());
    }

    @Override
    public void close() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        logger.info((Object)("Initializing: " + this.configurationClass));
        SpringApplicationBuilder builder = this.springApplication();
        ConfigurableApplicationContext context = builder.web(false).run(new String[0]);
        context.getAutowireCapableBeanFactory().autowireBean((Object)this);
        String name = context.getEnvironment().getProperty("function.name");
        boolean defaultName = false;
        if (name == null) {
            name = "function";
            defaultName = true;
        }
        if (this.catalog == null) {
            this.function = (Function)context.getBean(name, Function.class);
        } else {
            this.function = (Function)this.catalog.lookup(Function.class, name);
            if (this.function == null) {
                if (defaultName) {
                    name = "consumer";
                }
                this.function = (Function)this.catalog.lookup(Function.class, name);
                if (this.function == null) {
                    this.consumer = (Consumer)this.catalog.lookup(Consumer.class, name);
                    if (this.consumer == null) {
                        if (defaultName) {
                            name = "supplier";
                        }
                        this.supplier = (Supplier)this.catalog.lookup(Supplier.class, name);
                    }
                }
            }
        }
        this.context = context;
    }

    private SpringApplicationBuilder springApplication() {
        if (ClassUtils.hasConstructor(SpringApplicationBuilder.class, (Class[])new Class[]{Object[].class})) {
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{this.configurationClass});
            return builder;
        }
        return (SpringApplicationBuilder)BeanUtils.instantiateClass((Constructor)ClassUtils.getConstructorIfAvailable(SpringApplicationBuilder.class, (Class[])new Class[]{Class[].class}), (Object[])new Object[]{new Class[]{this.configurationClass}});
    }

    protected Class<?> getInputType() {
        if (this.inspector != null) {
            return this.inspector.getInputType(this.function());
        }
        return Object.class;
    }

    protected Object function() {
        return this.function != null ? this.function : (this.consumer != null ? this.consumer : this.supplier);
    }

    protected Flux<?> apply(Flux<?> input) {
        if (this.function != null) {
            return Flux.from(this.function.apply(input));
        }
        if (this.consumer != null) {
            this.consumer.accept(input);
            return Flux.empty();
        }
        if (this.supplier != null) {
            return this.supplier.get();
        }
        throw new IllegalStateException("No function defined");
    }

    private static Class<?> getStartClass() {
        ClassLoader classLoader = SpringFunctionInitializer.class.getClassLoader();
        if (System.getenv("MAIN_CLASS") != null) {
            return ClassUtils.resolveClassName((String)System.getenv("MAIN_CLASS"), (ClassLoader)classLoader);
        }
        try {
            Class<?> result = SpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("META-INF/MANIFEST.MF")));
            if (result == null) {
                result = SpringFunctionInitializer.getStartClass(Collections.list(classLoader.getResources("meta-inf/manifest.mf")));
            }
            logger.info((Object)("Main class: " + result));
            return result;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to find main class", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> getStartClass(List<URL> list) {
        logger.info((Object)("Searching manifests: " + list));
        Iterator<URL> iterator = list.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                logger.info((Object)("Searching manifest: " + url));
                try (InputStream inputStream = url.openStream();){
                    Manifest manifest = new Manifest(inputStream);
                    String startClass = manifest.getMainAttributes().getValue("Start-Class");
                    if (startClass == null) continue;
                    Class clazz = ClassUtils.forName((String)startClass, (ClassLoader)SpringFunctionInitializer.class.getClassLoader());
                    return clazz;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

