/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class FunctionInvoker
implements RequestStreamHandler {
    private static Log logger = LogFactory.getLog(FunctionInvoker.class);
    private ObjectMapper mapper;
    private SimpleFunctionRegistry.FunctionInvocationWrapper function;

    public FunctionInvoker() {
        this.start();
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        Message<byte[]> requestMessage = this.generateMessage(input, context);
        Message responseMessage = (Message)this.function.apply(requestMessage);
        byte[] responseBytes = (byte[])responseMessage.getPayload();
        if (requestMessage.getHeaders().containsKey((Object)"httpMethod") || requestMessage.getPayload() instanceof APIGatewayProxyRequestEvent) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("isBase64Encoded", false);
            MessageHeaders headers = responseMessage.getHeaders();
            int statusCode = headers.containsKey((Object)"statusCode") ? (Integer)headers.get((Object)"statusCode") : 200;
            response.put("statusCode", statusCode);
            if (this.isKinesis(requestMessage)) {
                HttpStatus httpStatus = HttpStatus.valueOf((int)statusCode);
                response.put("statusDescription", httpStatus.toString());
            }
            String body = new String((byte[])responseMessage.getPayload(), StandardCharsets.UTF_8).replaceAll("\\\"", "\"");
            response.put("body", body);
            HashMap responseHeaders = new HashMap();
            headers.keySet().forEach(key -> responseHeaders.put(key, headers.get(key).toString()));
            response.put("headers", responseHeaders);
            responseBytes = this.mapper.writeValueAsBytes(response);
        }
        StreamUtils.copy((byte[])responseBytes, (OutputStream)output);
    }

    private boolean isKinesis(Message<byte[]> requestMessage) {
        return requestMessage.getHeaders().containsKey((Object)"Records");
    }

    private void start() {
        ConfigurableApplicationContext context = SpringApplication.run((Class)FunctionClassUtils.getStartClass(), (String[])new String[0]);
        ConfigurableEnvironment environment = context.getEnvironment();
        String functionName = environment.getProperty("spring.cloud.function.definition");
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        this.mapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        this.configureObjectMapper();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Locating function: '" + functionName + "'"));
        }
        this.function = (SimpleFunctionRegistry.FunctionInvocationWrapper)functionCatalog.lookup(functionName, new String[]{"application/json"});
        Assert.notNull((Object)this.function, (String)("Failed to lookup function " + functionName));
        if (!StringUtils.hasText((String)functionName)) {
            FunctionInspector inspector = (FunctionInspector)context.getBean(FunctionInspector.class);
            functionName = inspector.getRegistration((Object)this.function).getNames().toString();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Located function: '" + functionName + "'"));
        }
        this.mapper.registerModule((Module)new JodaModule());
    }

    private void configureObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Date.class, (JsonDeserializer)new JsonDeserializer<Date>(){

            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(jsonParser.getValueAsLong());
                return calendar.getTime();
            }
        });
        this.mapper.registerModule((Module)module);
        this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    private Message<byte[]> generateMessage(InputStream input, Context context) throws IOException {
        boolean mapInputType;
        byte[] payload = StreamUtils.copyToByteArray((InputStream)input);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Incoming JSON for ApiGateway Event: " + new String(payload)));
        }
        MessageBuilder messageBuilder = null;
        Object request = this.mapper.readValue(payload, Object.class);
        Type inputType = this.function.getInputType();
        if (FunctionTypeUtils.isMessage((Type)inputType)) {
            inputType = FunctionTypeUtils.getImmediateGenericType((Type)inputType, (int)0);
        }
        boolean bl = mapInputType = inputType instanceof ParameterizedType && ((Class)((ParameterizedType)inputType).getRawType()).isAssignableFrom(Map.class);
        if (request instanceof Map) {
            Map requestMap = (Map)request;
            if (requestMap.containsKey("Records")) {
                List records = (List)requestMap.get("Records");
                Assert.notEmpty((Collection)records, (String)("Incoming event has no records: " + requestMap));
                this.logEvent(records);
                messageBuilder = MessageBuilder.withPayload((Object)payload);
            } else if (requestMap.containsKey("httpMethod")) {
                logger.info((Object)"Incoming request is API Gateway");
                if (inputType.getTypeName().endsWith(APIGatewayProxyRequestEvent.class.getSimpleName())) {
                    APIGatewayProxyRequestEvent gatewayEvent = (APIGatewayProxyRequestEvent)this.mapper.convertValue((Object)requestMap, APIGatewayProxyRequestEvent.class);
                    messageBuilder = MessageBuilder.withPayload((Object)gatewayEvent);
                } else if (mapInputType) {
                    messageBuilder = MessageBuilder.withPayload((Object)requestMap).setHeader("httpMethod", requestMap.get("httpMethod"));
                } else {
                    Object body = requestMap.remove("body");
                    body = body instanceof String ? String.valueOf(body).getBytes(StandardCharsets.UTF_8) : this.mapper.writeValueAsBytes(body);
                    messageBuilder = MessageBuilder.withPayload(body).copyHeaders(requestMap);
                }
            }
        }
        if (messageBuilder == null) {
            messageBuilder = MessageBuilder.withPayload((Object)payload);
        }
        return messageBuilder.setHeader("aws-context", (Object)context).build();
    }

    private void logEvent(List<Map<String, ?>> records) {
        if (this.isKinesisEvent(records.get(0))) {
            logger.info((Object)"Incoming request is Kinesis Event");
        } else if (this.isS3Event(records.get(0))) {
            logger.info((Object)"Incoming request is S3 Event");
        } else if (this.isSNSEvent(records.get(0))) {
            logger.info((Object)"Incoming request is SNS Event");
        } else {
            logger.info((Object)"Incoming request is SQS Event");
        }
    }

    private boolean isSNSEvent(Map<String, ?> record) {
        return record.containsKey("Sns");
    }

    private boolean isS3Event(Map<String, ?> record) {
        return record.containsKey("s3");
    }

    private boolean isKinesisEvent(Map<String, ?> record) {
        return record.containsKey("kinesis");
    }
}

