/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import javax.tools.JavaFileObject;

public abstract class CloseableFilterableJavaFileObjectIterable
implements Iterable<JavaFileObject> {
    private static final boolean BOOT_PACKAGING_AWARE = true;
    private static final String BOOT_PACKAGING_PREFIX_FOR_CLASSES = "BOOT-INF/classes/";
    private String packageNameFilter;
    private boolean includeSubpackages;

    public CloseableFilterableJavaFileObjectIterable(String packageNameFilter, boolean includeSubpackages) {
        if (packageNameFilter != null && packageNameFilter.contains(File.separator)) {
            throw new IllegalArgumentException("Package name filters should use dots to separate components: " + packageNameFilter);
        }
        this.packageNameFilter = packageNameFilter == null ? null : packageNameFilter.replace('.', '/') + '/';
        this.includeSubpackages = includeSubpackages;
    }

    protected boolean accept(String name) {
        boolean accept;
        if (!name.endsWith(".class")) {
            return false;
        }
        if (this.packageNameFilter == null) {
            return true;
        }
        name = name.replace('\\', '/');
        if (this.includeSubpackages) {
            accept = name.startsWith(this.packageNameFilter);
            if (!accept) {
                accept = name.startsWith(BOOT_PACKAGING_PREFIX_FOR_CLASSES) && name.indexOf(this.packageNameFilter) == BOOT_PACKAGING_PREFIX_FOR_CLASSES.length();
            }
        } else {
            boolean bl = accept = name.startsWith(this.packageNameFilter) && name.indexOf("/", this.packageNameFilter.length()) == -1;
            if (!accept) {
                accept = name.startsWith(BOOT_PACKAGING_PREFIX_FOR_CLASSES) && name.indexOf(this.packageNameFilter) == BOOT_PACKAGING_PREFIX_FOR_CLASSES.length() && name.indexOf("/", BOOT_PACKAGING_PREFIX_FOR_CLASSES.length() + this.packageNameFilter.length()) == -1;
            }
        }
        return accept;
    }

    abstract void close();
}

