/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.tools.JavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.function.compiler.java.CloseableFilterableJavaFileObjectIterable;
import org.springframework.cloud.function.compiler.java.DirEntryJavaFileObject;
import org.springframework.cloud.function.compiler.java.DirEnumeration;
import org.springframework.cloud.function.compiler.java.NestedZipEntryJavaFileObject;
import org.springframework.cloud.function.compiler.java.ZipEntryJavaFileObject;

public class IterableClasspath
extends CloseableFilterableJavaFileObjectIterable {
    private static Logger logger = LoggerFactory.getLogger(IterableClasspath.class);
    private static final String BOOT_PACKAGING_PREFIX_FOR_LIBRARIES = "BOOT-INF/lib/";
    private List<File> classpathEntries = new ArrayList<File>();
    private List<ZipFile> openArchives = new ArrayList<ZipFile>();

    IterableClasspath(String classpath, String packageNameFilter, boolean includeSubpackages) {
        super(packageNameFilter, includeSubpackages);
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            String nextEntry = tokenizer.nextToken();
            File f = new File(nextEntry);
            if (f.exists()) {
                this.classpathEntries.add(f);
                continue;
            }
            logger.debug("path element does not exist {}", (Object)f);
        }
    }

    @Override
    public void close() {
        for (ZipFile openArchive : this.openArchives) {
            try {
                openArchive.close();
            }
            catch (IOException ioe) {
                logger.debug("Unexpected error closing archive {}", (Object)openArchive, (Object)ioe);
            }
        }
        this.openArchives.clear();
    }

    @Override
    public Iterator<JavaFileObject> iterator() {
        return new ClasspathEntriesIterator();
    }

    static class ZipEnumerator
    implements Enumeration<ZipEntry> {
        private ZipInputStream zis;
        private ZipEntry nextEntry = null;

        public ZipEnumerator(ZipInputStream zis) {
            this.zis = zis;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                this.nextEntry = this.zis.getNextEntry();
            }
            catch (IOException ioe) {
                this.nextEntry = null;
            }
            return this.nextEntry != null;
        }

        @Override
        public ZipEntry nextElement() {
            ZipEntry retval = this.nextEntry;
            this.nextEntry = null;
            return retval;
        }
    }

    class ClasspathEntriesIterator
    implements Iterator<JavaFileObject> {
        private int currentClasspathEntriesIndex = 0;
        private File openDirectory = null;
        private DirEnumeration openDirectoryEnumeration = null;
        private ZipFile openArchive = null;
        private File openFile = null;
        private ZipEntry nestedZip = null;
        private Stack<Enumeration<? extends ZipEntry>> openArchiveEnumeration = null;
        private JavaFileObject nextEntry = null;

        ClasspathEntriesIterator() {
        }

        private void findNext() {
            if (this.nextEntry == null) {
                try {
                    while (this.openArchive != null || this.openDirectory != null || this.currentClasspathEntriesIndex < IterableClasspath.this.classpathEntries.size()) {
                        Object entry;
                        if (this.openArchive == null && this.openDirectory == null) {
                            File nextFile = (File)IterableClasspath.this.classpathEntries.get(this.currentClasspathEntriesIndex);
                            if (nextFile.isDirectory()) {
                                this.openDirectory = nextFile;
                                this.openDirectoryEnumeration = new DirEnumeration(nextFile);
                            } else {
                                this.openFile = nextFile;
                                this.openArchive = new ZipFile(nextFile);
                                IterableClasspath.this.openArchives.add(this.openArchive);
                                this.openArchiveEnumeration = new Stack();
                                this.openArchiveEnumeration.push(this.openArchive.entries());
                            }
                            ++this.currentClasspathEntriesIndex;
                        }
                        if (this.openArchiveEnumeration != null) {
                            while (!this.openArchiveEnumeration.isEmpty()) {
                                while (this.openArchiveEnumeration.peek().hasMoreElements()) {
                                    entry = this.openArchiveEnumeration.peek().nextElement();
                                    String entryName = ((ZipEntry)entry).getName();
                                    if (IterableClasspath.this.accept(entryName)) {
                                        this.nextEntry = this.nestedZip != null ? new NestedZipEntryJavaFileObject(this.openFile, this.openArchive, this.nestedZip, (ZipEntry)entry) : new ZipEntryJavaFileObject(this.openFile, this.openArchive, (ZipEntry)entry);
                                        return;
                                    }
                                    if (this.nestedZip != null || !entryName.startsWith(IterableClasspath.BOOT_PACKAGING_PREFIX_FOR_LIBRARIES) || !entryName.endsWith(".jar")) continue;
                                    logger.debug("opening nested archive {}", (Object)((ZipEntry)entry).getName());
                                    ZipInputStream zis = new ZipInputStream(this.openArchive.getInputStream((ZipEntry)entry));
                                    ZipEnumerator nestedZipEnumerator = new ZipEnumerator(zis);
                                    this.nestedZip = entry;
                                    this.openArchiveEnumeration.push(nestedZipEnumerator);
                                }
                                this.openArchiveEnumeration.pop();
                                if (this.nestedZip == null) {
                                    this.openArchive = null;
                                    this.openFile = null;
                                    continue;
                                }
                                this.nestedZip = null;
                            }
                            this.openArchiveEnumeration = null;
                            this.openArchive = null;
                            this.openFile = null;
                            continue;
                        }
                        if (this.openDirectoryEnumeration == null) continue;
                        while (this.openDirectoryEnumeration.hasMoreElements()) {
                            entry = this.openDirectoryEnumeration.nextElement();
                            String name = this.openDirectoryEnumeration.getName((File)entry);
                            if (!IterableClasspath.this.accept(name)) continue;
                            this.nextEntry = new DirEntryJavaFileObject(this.openDirectoryEnumeration.getDirectory(), (File)entry);
                            return;
                        }
                        this.openDirectoryEnumeration = null;
                        this.openDirectory = null;
                    }
                }
                catch (IOException ioe) {
                    logger.debug("Unexpected error whilst processing classpath entries", (Throwable)ioe);
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.nextEntry != null;
        }

        @Override
        public JavaFileObject next() {
            this.findNext();
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            JavaFileObject retval = this.nextEntry;
            this.nextEntry = null;
            return retval;
        }
    }
}

