/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.function.compiler.java.CloseableFilterableJavaFileObjectIterable;
import org.springframework.cloud.function.compiler.java.CompilationMessage;
import org.springframework.cloud.function.compiler.java.CompilationOutputCollector;
import org.springframework.cloud.function.compiler.java.CompiledClassDefinition;
import org.springframework.cloud.function.compiler.java.DependencyResolver;
import org.springframework.cloud.function.compiler.java.InMemoryJavaFileObject;
import org.springframework.cloud.function.compiler.java.IterableClasspath;

public class MemoryBasedJavaFileManager
implements JavaFileManager {
    private static Logger logger = LoggerFactory.getLogger(MemoryBasedJavaFileManager.class);
    private CompilationOutputCollector outputCollector;
    private List<CloseableFilterableJavaFileObjectIterable> toClose = new ArrayList<CloseableFilterableJavaFileObjectIterable>();
    private Map<String, File> resolvedAdditionalDependencies = new LinkedHashMap<String, File>();

    public MemoryBasedJavaFileManager() {
        this.outputCollector = new CompilationOutputCollector();
    }

    @Override
    public int isSupportedOption(String option) {
        logger.debug("isSupportedOption({})", (Object)option);
        return -1;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        logger.debug("getClassLoader({})", (Object)location);
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        logger.debug("list({},{},{},{})", new Object[]{location, packageName, kinds, recurse});
        String classpath = "";
        if (location == StandardLocation.PLATFORM_CLASS_PATH && (kinds == null || kinds.contains((Object)JavaFileObject.Kind.CLASS))) {
            classpath = System.getProperty("sun.boot.class.path");
            logger.debug("Creating iterable for boot class path: {}", (Object)classpath);
        } else if (location == StandardLocation.CLASS_PATH && (kinds == null || kinds.contains((Object)JavaFileObject.Kind.CLASS))) {
            String javaClassPath = this.getClassPath();
            if (!this.resolvedAdditionalDependencies.isEmpty()) {
                for (File resolvedAdditionalDependency : this.resolvedAdditionalDependencies.values()) {
                    javaClassPath = javaClassPath + File.pathSeparatorChar + resolvedAdditionalDependency.toURI().toString().substring("file:".length());
                }
            }
            classpath = javaClassPath;
            logger.debug("Creating iterable for class path: {}", (Object)classpath);
        }
        IterableClasspath resultIterable = new IterableClasspath(classpath, packageName, recurse);
        this.toClose.add(resultIterable);
        return resultIterable;
    }

    private String getClassPath() {
        URL[] urls;
        ClassLoader loader = InMemoryJavaFileObject.class.getClassLoader();
        if (loader instanceof URLClassLoader && (urls = ((URLClassLoader)loader).getURLs()).length > 1) {
            StringBuilder builder = new StringBuilder();
            for (URL url : urls) {
                String path;
                if (builder.length() > 0) {
                    builder.append(File.pathSeparator);
                }
                if ((path = url.toString()).startsWith("file:")) {
                    path = path.substring("file:".length());
                }
                builder.append(path);
            }
            return builder.toString();
        }
        return System.getProperty("java.class.path");
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        logger.debug("hasLocation({})", (Object)location);
        return location == StandardLocation.SOURCE_PATH || location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.SOURCE_PATH) {
            return null;
        }
        String classname = file.getName().replace('/', '.').replace('\\', '.');
        return classname.substring(0, classname.lastIndexOf(".class"));
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        logger.debug("isSameFile({},{})", (Object)a, (Object)b);
        return a.equals(b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        logger.debug("handleOption({},{})", (Object)current, remaining);
        return false;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        logger.debug("getJavaFileForInput({},{},{})", new Object[]{location, className, kind});
        throw new IllegalStateException("Not expected to be used in this context");
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        logger.debug("getJavaFileForOutput({},{},{},{})", new Object[]{location, className, kind, sibling});
        return this.outputCollector.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        logger.debug("getFileForInput({},{},{})", new Object[]{location, packageName, relativeName});
        throw new IllegalStateException("Not expected to be used in this context");
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        logger.debug("getFileForOutput({},{},{},{})", new Object[]{location, packageName, relativeName, sibling});
        return this.outputCollector.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        for (CloseableFilterableJavaFileObjectIterable closeable : this.toClose) {
            closeable.close();
        }
    }

    public List<CompiledClassDefinition> getCompiledClasses() {
        return this.outputCollector.getCompiledClasses();
    }

    public List<CompilationMessage> addAndResolveDependencies(String[] dependencies) {
        ArrayList<CompilationMessage> resolutionMessages = new ArrayList<CompilationMessage>();
        for (String dependency : dependencies) {
            if (dependency.startsWith("maven:")) {
                String coordinates = dependency.replaceFirst("maven:\\/*", "");
                DependencyResolver engine = DependencyResolver.instance();
                try {
                    File resolved = engine.resolve(new Dependency((Artifact)new DefaultArtifact(coordinates), "runtime"));
                    this.resolvedAdditionalDependencies.put(dependency, resolved);
                }
                catch (RuntimeException re) {
                    CompilationMessage compilationMessage = new CompilationMessage(CompilationMessage.Kind.ERROR, re.getMessage(), null, 0, 0);
                    resolutionMessages.add(compilationMessage);
                }
                continue;
            }
            resolutionMessages.add(new CompilationMessage(CompilationMessage.Kind.ERROR, "Unrecognized dependency: " + dependency + " (expected something of the form: maven://groupId:artifactId:version)", null, 0, 0));
        }
        return resolutionMessages;
    }

    public Map<String, File> getResolvedAdditionalDependencies() {
        return this.resolvedAdditionalDependencies;
    }
}

