/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class SimpleClassLoader
extends URLClassLoader {
    private static final URL[] NO_URLS = new URL[0];

    public SimpleClassLoader(ClassLoader classLoader) {
        super(NO_URLS, classLoader);
    }

    public SimpleClassLoader(List<File> resolvedAdditionalDependencies, ClassLoader classLoader) {
        super(SimpleClassLoader.toUrls(resolvedAdditionalDependencies), classLoader);
    }

    private static URL[] toUrls(List<File> resolvedAdditionalDependencies) {
        URL[] urls = new URL[resolvedAdditionalDependencies.size()];
        int max = resolvedAdditionalDependencies.size();
        for (int i = 0; i < max; ++i) {
            try {
                urls[i] = resolvedAdditionalDependencies.get(i).toURI().toURL();
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return urls;
    }

    public Class<?> defineClass(String name, byte[] bytes) {
        return super.defineClass(name, bytes, 0, bytes.length);
    }
}

